package com.ejianc.business.sub.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 工人现场统计明细
 * 
 * @author generator
 * 
 */
public class WorkerPresentDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pid; // 工人在场统计id
    private String workerName; // 工人姓名
    private Long workType; // 工种
    private String phone;//手机号
    private String idCard;//身份证号
    private String bankAccount;//银行卡号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date enterDate; // 进场日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date departureDate; // 离场日期
    private Boolean presentFlag; // 是否在场
    private Integer presentDays; // 在场天数
    private String memo; // 备注

    private String presentFlagStr; // 是否在场 字符
    private String workTypeName;//工种名称
    /**
     * 导入失败原因
     */
    private String errorMessage;

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public String getWorkerName() {
        return workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getWorkType() {
        return workType;
    }
    @ReferDeserialTransfer
    public void setWorkType(Long workType) {
        this.workType = workType;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Date getEnterDate() {
        return enterDate;
    }

    public void setEnterDate(Date enterDate) {
        this.enterDate = enterDate;
    }
    public Date getDepartureDate() {
        return departureDate;
    }

    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }
    public Boolean getPresentFlag() {
        return presentFlag;
    }

    public void setPresentFlag(Boolean presentFlag) {
        this.presentFlag = presentFlag;
    }
    public Integer getPresentDays() {
        return presentDays;
    }

    public void setPresentDays(Integer presentDays) {
        this.presentDays = presentDays;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getPresentFlagStr() {
        return presentFlagStr;
    }

    public void setPresentFlagStr(String presentFlagStr) {
        this.presentFlagStr = presentFlagStr;
    }

    public String getWorkTypeName() {
        return workTypeName;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
