package com.ejianc.business.sub.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.sub.hystrix.SubContractInvoiceReceiveHystrix;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * 获取合同参照工厂类方法
 * 
 * @author yqls
 *
 */
@FeignClient(name= "ejc-sub-web", url="${common.env.feign-client-url}", path="ejc-sub-web", fallback = SubContractInvoiceReceiveHystrix.class)
public interface ISubContractInvoiceReceiveApi {
	/**
	 * 根据条件查询不同合同类型的合同
	 * @return
	 */
	@PostMapping(value = "/api/sub/getSubContractById")
	public CommonResponse<ContractResVO> getContractById(@RequestParam(value = "settleId", required = true) Long contractId);

	@PostMapping(value = "/api/sub/afterApproveInvoiceReceive")
	CommonResponse<String> afterApproveInvoiceReceive(@RequestParam(value="contractId", required=true) Long contractId,
														  @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny);

	@PostMapping(value = "/api/sub/afterRevocationInvoiceReceive")
	CommonResponse<JSONObject> afterRevocationInvoiceReceive(@RequestParam(value="contractId", required=true) Long contractId,
																 @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny);
}
