package com.ejianc.business.sub.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 分包结算（过程结算 + 完工结算）
 * </p>
 *
 * @author yqls
 * @since 2020-07-15
 */
public class SubSettleVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 结算单号
     */
    private String  billCode;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 剩余可冲抵金额
     */
    private BigDecimal symny;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 分包供应商
     */
    private Long supplierId;

    /**
     * 分包供应商名称
     */
    private String supplierName;

    /**
     * 结算日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate;

    /**
     * 分包类型
     */
    private Long contractType;

    /**
     * 分包合同金额(不含税)
     */
    private BigDecimal contractMny;

    /**
     * 分包合同金额
     */
    private BigDecimal contractTaxMny;

    /**
     * 合同税率
     */
    private BigDecimal taxRate;

    /**
     * 本期结算金额(不含税)
     */
    private BigDecimal settleMny;

    /**
     * 本期结算金额(含税)
     */
    private BigDecimal settleTaxMny;

    /**
     * 本期零工结算金额(不含税)
     */
    private BigDecimal oddjobMny;

    /**
     * 本期零工结算金额(含税)
     */
    private BigDecimal oddjobTaxMny;

    /**
     * 本期其他结算金额(不含税)
     */
    private BigDecimal otherMny;

    /**
     * 本期其他结算金额(含税)
     */
    private BigDecimal otherTaxMny;

    /**
     * 税金
     */
    private BigDecimal taxMny;

    /**
     * 本次冲抵金额
     */
    private BigDecimal offsetMny;

    /**
     * 累计预付款金额
     */
    private BigDecimal sumPrepayMny;

    /**
     * 累计付款金额
     */
    private BigDecimal sumPayMny;

    /**
     * 累计冲抵金额
     */
    private BigDecimal sumOffsetMny;

    /**
     * 累计结算金额(不含税)
     */
    private BigDecimal sumSettleMny;

    /**
     * 累计结算金额
     */
    private BigDecimal sumSettleTaxMny;

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    /**
     * 累计已申请金额
     */
    private BigDecimal sumApplyMny;

    /**
     * 剩余可申请金额
     */
    private BigDecimal surplusApplyMny;

    /**
     * 结算单类型：1-过程结算，2-完工结算
     */
    private Integer settleType;

    /**
     * 完工结算应付金额（含税）
     */
    private BigDecimal shouldPayTaxMny;

    /**
     * 备注
     */
    private String memo;

    public BigDecimal getShouldPayTaxMny() {
        return shouldPayTaxMny;
    }

    public void setShouldPayTaxMny(BigDecimal shouldPayTaxMny) {
        this.shouldPayTaxMny = shouldPayTaxMny;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public BigDecimal getSurplusApplyMny() {
        return surplusApplyMny;
    }

    public void setSurplusApplyMny(BigDecimal surplusApplyMny) {
        this.surplusApplyMny = surplusApplyMny;
    }

    public BigDecimal getSymny() {
        return symny;
    }

    public void setSymny(BigDecimal symny) {
        this.symny = symny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="sub-contract-register")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }
    public BigDecimal getOddjobMny() {
        return oddjobMny;
    }

    public void setOddjobMny(BigDecimal oddjobMny) {
        this.oddjobMny = oddjobMny;
    }
    public BigDecimal getOddjobTaxMny() {
        return oddjobTaxMny;
    }

    public void setOddjobTaxMny(BigDecimal oddjobTaxMny) {
        this.oddjobTaxMny = oddjobTaxMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getOffsetMny() {
        return offsetMny;
    }

    public void setOffsetMny(BigDecimal offsetMny) {
        this.offsetMny = offsetMny;
    }
    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }
    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }
    public BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    public void setSumOffsetMny(BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }
    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
