package com.ejianc.business.sub.api;

import com.ejianc.business.sub.hystrix.CertificateApiHystrix;
import com.ejianc.business.sub.hystrix.SubContractHystrix;
import com.ejianc.business.sub.vo.CertificateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@FeignClient(name = "ejc-sub-web", url = "${common.env.feign-client-url}", path = "ejc-sub-web", fallback = CertificateApiHystrix.class)
public interface ICertificateApi {
    /**
     * 更加对外签证单id查询对内签证
     * @param certificateId
     * @return
     */
    @RequestMapping(value = "api/certificate/getByCertificateId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CertificateVO>> getByCertificateId(@RequestParam(value = "certificateId") Long certificateId);

}
