package com.ejianc.business.sub.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 分包结算汇总表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public class SettleReportVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    private Long contractId;


    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 结算主键
     */
    private Long settleId;

    /**
     * 结算单号
     */
    private String  billCode;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;


    /**
     * 分包供应商
     */
    private Long supplierId;

    /**
     * 分包供应商名称
     */
    private String supplierName;

    /**
     * 结算日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate;


    /**
     * 分包合同金额
     */
    private BigDecimal contractTaxMny;


    /**
     * 本期结算金额
     */
    private BigDecimal settleTaxMny;

    /**
     * 累计结算金额(含本期)
     */
    private BigDecimal sumSettleTaxMny;


    /**
     * 本期付款金额
     */
    private BigDecimal payMny;

    /**
     * 累计付款金额（含本期）
     */
    private BigDecimal sumPayMny;


    /**
     * 过程结算明细集合
     */
    private List<SettleReportDetailVO> settleDetailList;

    /**
     * 过程结算零工集合
     */
    private List<SettleReportOddjobVO> settleOddjobList;

    /**
     * 过程结算其他集合
     */
    private List<SettleReportOtherVO> settleOtherList;

    @ReferSerialTransfer(referCode="sub-contract-register")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="sub-settle-register")
    public Long getSettleId() {
        return settleId;
    }

    @ReferDeserialTransfer
    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public List<SettleReportDetailVO> getSettleDetailList() {
        return settleDetailList;
    }

    public void setSettleDetailList(List<SettleReportDetailVO> settleDetailList) {
        this.settleDetailList = settleDetailList;
    }

    public List<SettleReportOddjobVO> getSettleOddjobList() {
        return settleOddjobList;
    }

    public void setSettleOddjobList(List<SettleReportOddjobVO> settleOddjobList) {
        this.settleOddjobList = settleOddjobList;
    }

    public List<SettleReportOtherVO> getSettleOtherList() {
        return settleOtherList;
    }

    public void setSettleOtherList(List<SettleReportOtherVO> settleOtherList) {
        this.settleOtherList = settleOtherList;
    }
}
