package com.ejianc.business.sub.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 分包签证单-扣款详情
 * 
 * @author generator
 * 
 */
public class CertificateDeductionVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Date billDate; // 填写日期
    private String billCode; // 编码规则
    private Integer billState; // 单据状态（审批必须字段）
    private Long contractIdDeduction; // 分包合同ID
    private String contractCodeDeduction; // 分包合同编码
    private String contractNameDeduction; // 分包合同名称
    private Long supplierIdDeduction; // 分包企业ID
    private String supplierNameDeduction; // 分包企业名称
    private BigDecimal deductionMny; // 扣款金额
    private Long pid; // 单据id
    

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "sub-contract-register")
    public Long getContractIdDeduction() {
        return contractIdDeduction;
    }
    @ReferDeserialTransfer
    public void setContractIdDeduction(Long contractIdDeduction) {
        this.contractIdDeduction = contractIdDeduction;
    }

    public String getContractCodeDeduction() {
        return contractCodeDeduction;
    }

    public void setContractCodeDeduction(String contractCodeDeduction) {
        this.contractCodeDeduction = contractCodeDeduction;
    }
    public String getContractNameDeduction() {
        return contractNameDeduction;
    }

    public void setContractNameDeduction(String contractNameDeduction) {
        this.contractNameDeduction = contractNameDeduction;
    }
    public Long getSupplierIdDeduction() {
        return supplierIdDeduction;
    }

    public void setSupplierIdDeduction(Long supplierIdDeduction) {
        this.supplierIdDeduction = supplierIdDeduction;
    }
    public String getSupplierNameDeduction() {
        return supplierNameDeduction;
    }

    public void setSupplierNameDeduction(String supplierNameDeduction) {
        this.supplierNameDeduction = supplierNameDeduction;
    }
    public BigDecimal getDeductionMny() {
        return deductionMny;
    }

    public void setDeductionMny(BigDecimal deductionMny) {
        this.deductionMny = deductionMny;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
