package com.ejianc.business.sub.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.sub.vo.WorkerPresentDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工人在场统计
 * 
 * @author generator
 * 
 */
public class WorkerPresentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 所属项目Id
    private String projectName; // 所属项目名称
    private String projectCode; // 所属项目编码
    private String billCode; // 单据编码
    private Long orgId; // 所属项目部Id
    private String orgName; // 所属项目部名称
    private Integer billState; // 单据状态
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办部门id
    private String departmentName; // 经办部门
    private Long supplierId; // 分包单位
    private String supplierName; // 分包单位
    private Long contractId; // 合同主键
    private String contractName; // 合同名称
    private Integer presentNum; // 在场人数
    private String memo; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 编制日期

    
    private List<WorkerPresentDetailVO> workerPresentDetailList = new ArrayList<>(); // 工人现场统计明细

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    @ReferSerialTransfer(referCode="sub-contract-register")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Integer getPresentNum() {
        return presentNum;
    }

    public void setPresentNum(Integer presentNum) {
        this.presentNum = presentNum;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    
     public List<WorkerPresentDetailVO> getWorkerPresentDetailList() {
        return workerPresentDetailList;
     }

     public void setWorkerPresentDetailList(List<WorkerPresentDetailVO> workerPresentDetailList) {
        this.workerPresentDetailList = workerPresentDetailList;
     }
}
