/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.sub.bean.OddjobContentEntity;
import com.ejianc.business.sub.bean.OddjobEntity;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.vo.OddjobContentVo;
import com.ejianc.business.sub.vo.OddjobRecordVO;
import com.ejianc.business.sub.vo.OddjobVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"oddjob"})
public class OddjobController
implements Serializable {
    @Autowired
    IOddjobService oddjobService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OddjobVO> saveOrUpdate(@RequestBody OddjobVO oddjobVO) {
        OddjobVO vo = this.oddjobService.insertOrUpdate(oddjobVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OddjobVO> queryDetail(Long id) {
        OddjobVO vo = this.oddjobService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OddjobVO>> queryList(@RequestBody QueryParam param) {
        return this.oddjobService.queryListVOs(param);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddjobVO> vos) {
        return this.oddjobService.deleteByIds(vos);
    }

    @RequestMapping(value={"/oddjobRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OddjobVO>> oddjobRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("bill_code");
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setPageIndex(pageNumber.intValue());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.setSearchText(searchText);
        }
        Long contractId = null;
        Long orgId = null;
        Long projectId = null;
        String paySporadicRef = null;
        Long supplierId = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                contractId = Long.valueOf(conditionMap.get("contractId").toString());
            }
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            }
            if (null != conditionMap.get("paySporadicRef")) {
                paySporadicRef = conditionMap.get("paySporadicRef").toString();
            }
            if (null != conditionMap.get("supplierId")) {
                supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
            }
        }
        if (null != orgId) {
            queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            UserContext userContext = this.sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            if (StringUtils.isNotEmpty((String)authOrgIds)) {
                CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
                queryParam.getParams().put("org_id", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            } else {
                queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        if (projectId != null) {
            queryParam.getParams().put("project_id", new Parameter("eq", (Object)projectId));
        }
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billstate));
        if (null != paySporadicRef && null != supplierId) {
            if (null == projectId) {
                return CommonResponse.success((String)"\u67e5\u8be2\u96f6\u5de5\u5217\u8868\u5931\u8d25\uff0c\u9879\u76ee\u4e3a\u5fc5\u4f20\u53c2\u6570\uff01", null);
            }
            queryParam.getParams().put("supplier_id", new Parameter("eq", (Object)supplierId));
            queryParam.getParams().put("is_use", new Parameter("eq", (Object)Boolean.FALSE));
            queryParam.getParams().put("contract_id", new Parameter("sql", (Object)"contract_id is null"));
        } else {
            if (null == contractId) {
                return CommonResponse.success((String)"\u67e5\u8be2\u96f6\u5de5\u5217\u8868\u5931\u8d25\uff0c\u5408\u540c\u4e3b\u952e\u4e3a\u5fc5\u4f20\u53c2\u6570\uff01", null);
            }
            queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
            queryParam.getParams().put("settle_flag", new Parameter("eq", (Object)0));
        }
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.oddjobService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), OddjobVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u5217\u8868\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/queryDetailAdd"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OddjobVO> queryDetailAdd(Long contractId) {
        OddjobVO vo = this.oddjobService.queryDetailAdd(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u67e5\u8be2\u5408\u540c\u8f6c\u5316\u4e3a\u96f6\u5de5\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OddjobRecordVO> queryDetailRecord(Long id) {
        OddjobRecordVO vo = this.oddjobService.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8bb0\u5f55\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        this.oddjobService.excelExport(param, response);
    }

    @PostMapping(value={"excelExportContentList"})
    public void excelExportContentList(@RequestBody OddjobVO oddjobVO, HttpServletResponse response) {
        OddjobEntity entity = (OddjobEntity)((Object)this.oddjobService.selectById(oddjobVO.getId()));
        HashMap beans = new HashMap();
        ArrayList list = new ArrayList();
        List<OddjobContentEntity> data = entity.getOddjobContentList();
        if (CollectionUtils.isNotEmpty(data)) {
            data.forEach(item -> {
                OddjobContentVo vo = (OddjobContentVo)BeanMapper.map((Object)item, OddjobContentVo.class);
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("oddjobContentExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"oddjobContent-import.xlsx", (String)"\u96f6\u661f\u7528\u5de5\u5185\u5bb9\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<OddjobContentVo> successList = new ArrayList<OddjobContentVo>();
        ArrayList<OddjobContentVo> errorList = new ArrayList<OddjobContentVo>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 5) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                OddjobContentVo oddjobContentVo = new OddjobContentVo();
                oddjobContentVo.setName((String)datas.get(0));
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    oddjobContentVo.setErrorMessage("\u5355\u4ef7\u4e3a\u5fc5\u586b\u9879");
                } else {
                    oddjobContentVo.setPrice(new BigDecimal((String)datas.get(1)));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    oddjobContentVo.setErrorMessage("\u6570\u91cf\u4e3a\u5fc5\u586b\u9879");
                } else {
                    oddjobContentVo.setNum(new BigDecimal((String)datas.get(2)));
                }
                BigDecimal money = ComputeUtil.safeMultiply((BigDecimal)oddjobContentVo.getPrice(), (BigDecimal)oddjobContentVo.getNum());
                if (!"".equals(datas.get(3)) && datas.get(3) != null) {
                    if (money.equals(new BigDecimal((String)datas.get(3)))) {
                        oddjobContentVo.setMoney(ComputeUtil.scale((BigDecimal)new BigDecimal((String)datas.get(3)), (int)2));
                    } else {
                        oddjobContentVo.setMoney(ComputeUtil.scale((BigDecimal)money, (int)2));
                    }
                } else {
                    oddjobContentVo.setMoney(ComputeUtil.scale((BigDecimal)money, (int)2));
                }
                oddjobContentVo.setMemo((String)datas.get(4));
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)oddjobContentVo.getErrorMessage())) {
                    successList.add(oddjobContentVo);
                    continue;
                }
                errorList.add(oddjobContentVo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/checkAllParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkAllParams(@RequestBody OddjobVO vo) {
        ParamsCheckVO paramsCheckVO = this.oddjobService.checkAllParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"/querySumOddjobMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OddjobVO> querySumOddjobMny(Long contractId) {
        OddjobVO oddjobVO = this.oddjobService.querySumOddjobMny(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)oddjobVO);
    }
}

