/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.FinishCostEntity;
import com.ejianc.business.sub.bean.FinishDetailEntity;
import com.ejianc.business.sub.bean.FinishEntity;
import com.ejianc.business.sub.bean.OddjobEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.mapper.FinishMapper;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IFinishCostService;
import com.ejianc.business.sub.service.IFinishDetailService;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.BigDecimalUtils;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.FinishCostVO;
import com.ejianc.business.sub.vo.FinishDetailVO;
import com.ejianc.business.sub.vo.FinishRecordDetailVO;
import com.ejianc.business.sub.vo.FinishRecordVO;
import com.ejianc.business.sub.vo.FinishVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="FinishServiceImpl")
public class FinishServiceImpl
extends BaseServiceImpl<FinishMapper, FinishEntity>
implements IFinishService {
    private static final String SUB_FINISH_BILL_CODE = "SUB_FINISH";
    private static final String SUB_FINISH = "SUB_FINISH";
    private static final String SUB_FINISH_COST = "SUB_FINISH_COST";
    private static final String CHECK_PARAM_CODE = "P-2452lK17";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IFinishDetailService finishDetailService;
    @Autowired
    private IFinishCostService finishCostService;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IOddjobService oddJobService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IInvoiceApi invoiceApi;

    @Override
    public FinishVO insertOrUpdate(FinishVO finishVO) {
        FinishEntity oldFinish;
        Long oldContractId;
        CommonResponse invoiceReceiceMnyRes;
        Object shouldPayTaxMny;
        BigDecimal money;
        if (this.checkSameContract(finishVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u505a\u8fc7\u5b8c\u5de5\u7ed3\u7b97\uff01");
        }
        if (this.checkUnEffectSettle(finishVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u4e0e\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u8fc7\u7a0b\u7ed3\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        if (this.checkUnEffectOddjob(finishVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u4e0e\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u96f6\u661f\u7528\u5de5\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        if ((finishVO.getId() == null || finishVO.getId() <= 0L) && this.checkFinishContract(finishVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b8c\u5de5\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(finishVO.getContractId()), (String)BillTypeCodeEnum.\u5206\u5305\u5408\u540c.getBillTypeCode(), (Integer)finishVO.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)finishVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("SUB_FINISH", InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                finishVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (this.checkSameBillCode(finishVO).booleanValue()) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        finishVO.setRelationFlag("0");
        finishVO.setProportionFlag("0");
        FinishEntity finishEntity = (FinishEntity)((Object)BeanMapper.map((Object)finishVO, FinishEntity.class));
        List<FinishCostEntity> finishCostList = finishEntity.getFinishCostList();
        if (CollectionUtils.isNotEmpty(finishCostList) && (money = finishCostList.stream().map(FinishCostEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo((BigDecimal)(shouldPayTaxMny = finishEntity.getShouldPayTaxMny())) != 0) {
            throw new BusinessException("\u7ed3\u7b97\u5dee\u989d\u548c\u6210\u672c\u660e\u7ec6\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        List<FinishDetailEntity> beforeDetails = finishEntity.getFinishDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == finishEntity.getId()) {
            for (FinishDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        if ((invoiceReceiceMnyRes = this.invoiceApi.getInvoiceReceiceMny(finishEntity.getContractId(), finishEntity.getOrgId())).isSuccess()) {
            finishEntity.setSumInvoiceTaxMny(ComputeUtil.nullToZero((BigDecimal)((BigDecimal)invoiceReceiceMnyRes.getData())));
        }
        if (finishEntity.getId() != null && (oldContractId = (oldFinish = (FinishEntity)((Object)this.getById(finishEntity.getId()))).getContractId()) != null && !oldContractId.equals(finishEntity.getContractId())) {
            this.writeBackContractFinsishFlag(oldFinish, Boolean.FALSE);
        }
        super.saveOrUpdate((Object)finishEntity, false);
        List<FinishDetailEntity> finishDetailEntities = finishEntity.getFinishDetailList();
        if (CollectionUtils.isNotEmpty(finishDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (FinishDetailEntity cdEntity : finishDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (FinishDetailEntity cdEntity : finishDetailEntities) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.finishDetailService.saveOrUpdateBatch(finishDetailEntities, finishDetailEntities.size(), false);
        }
        this.writeBackContractFinsishFlag(finishEntity, Boolean.TRUE);
        return this.queryDetail(finishEntity.getId());
    }

    private Boolean checkSameBillCode(FinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(FinishEntity::getBillCode, (Object)finishVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != finishVO.getId() && finishVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)finishVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkSameContract(FinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(FinishEntity::getContractId, (Object)finishVO.getContractId());
        lambda.eq(FinishEntity::getOrgId, (Object)finishVO.getOrgId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != finishVO.getId() && finishVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)finishVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkUnEffectSettle(FinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getContractId, (Object)finishVO.getContractId());
        lambda.eq(SettleEntity::getOrgId, (Object)finishVO.getOrgId());
        lambda.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        return this.settleService.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkUnEffectOddjob(FinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(OddjobEntity::getContractId, (Object)finishVO.getContractId());
        lambda.eq(OddjobEntity::getOrgId, (Object)finishVO.getOrgId());
        lambda.notIn(OddjobEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        return this.oddJobService.list((Wrapper)lambda).size() > 0;
    }

    private Boolean checkFinishContract(FinishVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getId, (Object)finishVO.getContractId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(ContractEntity::getFinishFlag, (Object)true);
        return this.contractService.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public FinishVO queryDetail(Long id) {
        FinishEntity finishEntity = (FinishEntity)((Object)super.selectById((Serializable)id));
        FinishVO finishVO = (FinishVO)BeanMapper.map((Object)((Object)finishEntity), FinishVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("finishId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityList = this.finishDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (FinishDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, FinishDetailVO.class);
            FinishServiceImpl.sortIntMethod(resultMapList);
            List finishDetailVOS = TreeNodeBUtil.buildTree((List)resultMapList);
            finishVO.setFinishDetailList(finishDetailVOS);
        }
        finishVO.setUnPaidMoney(ComputeUtil.safeSub((BigDecimal)finishEntity.getSettleTaxMny(), (BigDecimal)finishEntity.getPaidMoney()));
        return finishVO;
    }

    private static void sortIntMethod(List<FinishDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                FinishDetailVO o1Detail = (FinishDetailVO)objectMapper.convertValue(o1, FinishDetailVO.class);
                FinishDetailVO o2Detail = (FinishDetailVO)objectMapper.convertValue(o2, FinishDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getTreeIndex().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public CommonResponse<IPage<FinishVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("memo");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        boolean payApplyFlagHasFree = param.getParams().containsKey("payApplyFlagHasFree");
        param.getParams().remove("payApplyFlagHasFree");
        IPage page = this.queryPage(param, false);
        List finishVOList = BeanMapper.mapList((Iterable)page.getRecords(), FinishVO.class);
        if (payApplyFlagHasFree && CollectionUtils.isNotEmpty((Collection)finishVOList)) {
            List settleIds = finishVOList.stream().map(e -> e.getId()).collect(Collectors.toList());
            CommonResponse applyMnyHasFreeRes = this.payContractApi.getApplyMnyHasFree(settleIds);
            Map settleApplyData = (Map)applyMnyHasFreeRes.getData();
            for (FinishVO subSettleVO : finishVOList) {
                BigDecimal sumApplyMnyHasFree = (BigDecimal)settleApplyData.get(subSettleVO.getId());
                subSettleVO.setSumApplyMny(sumApplyMnyHasFree);
                BigDecimal surplusApplyMny = ComputeUtil.safeSub((BigDecimal)subSettleVO.getSettleTaxMny(), (BigDecimal)sumApplyMnyHasFree);
                subSettleVO.setSurplusApplyMny(surplusApplyMny);
            }
        }
        Page finishVOIPage = new Page();
        finishVOIPage.setCurrent(page.getCurrent());
        finishVOIPage.setRecords(finishVOList);
        finishVOIPage.setSize(page.getSize());
        finishVOIPage.setTotal(page.getTotal());
        finishVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)finishVOIPage);
    }

    @Override
    public CommonResponse<String> deleteByIds(List<FinishVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List entityList = BeanMapper.mapList((Iterable)super.listByIds(ids), FinishEntity.class);
        for (FinishEntity finishEntity : entityList) {
            this.writeBackContractFinsishFlag(finishEntity, Boolean.FALSE);
        }
        if (CollectionUtils.isNotEmpty(vos)) {
            this.removeByIds(ids, false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public FinishRecordVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        FinishRecordVO finishRecordVO = new FinishRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null || contractEntity.getFinishFlag() == false ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumScale = BigDecimalUtils.safeDiv(sumSettleTaxMny, contractTaxMny).multiply(new BigDecimal(100));
        finishRecordVO.setContractId(id);
        finishRecordVO.setFinishFlag(contractEntity.getFinishFlag());
        finishRecordVO.setContractStatus(Integer.valueOf(contractEntity.getContractStatus()));
        finishRecordVO.setPurchaseType(Integer.valueOf(contractEntity.getPurchaseType()));
        finishRecordVO.setContractName(contractEntity.getContractName());
        finishRecordVO.setSupplierName(contractEntity.getSupplierName());
        finishRecordVO.setContractTaxMny(contractTaxMny);
        finishRecordVO.setSumSettleTaxMny(sumSettleTaxMny);
        finishRecordVO.setSumScale(sumScale);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(FinishEntity::getContractId, (Object)id);
        List entitiesAllState = super.list((Wrapper)lambda);
        lambda.in(FinishEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        List finishRecordDetailVOList = BeanMapper.mapList((Iterable)entities, FinishRecordDetailVO.class);
        if (CollectionUtils.isNotEmpty((Collection)finishRecordDetailVOList)) {
            finishRecordDetailVOList.forEach(entity -> {
                BigDecimal settleTaxMny = entity.getSettleTaxMny() == null ? BigDecimal.ZERO : entity.getSettleTaxMny();
                BigDecimal scale = contractTaxMny == BigDecimal.ZERO ? BigDecimal.ZERO : ComputeUtil.safeDiv((BigDecimal)settleTaxMny, (BigDecimal)contractTaxMny).multiply(new BigDecimal(100));
                entity.setSumScale(scale);
            });
        }
        finishRecordVO.setDetailList(BeanMapper.mapList((Iterable)entitiesAllState, FinishRecordDetailVO.class));
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(SettleEntity::getContractId, (Object)id);
        lambda2.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List settleList = this.settleService.list((Wrapper)lambda2);
        BigDecimal settleTaxMny = new BigDecimal(0);
        for (SettleEntity settle : settleList) {
            settleTaxMny = settleTaxMny.add(settle.getSettleTaxMny() == null ? BigDecimal.ZERO : settle.getSettleTaxMny());
        }
        finishRecordVO.setSettleTaxMny(settleTaxMny);
        finishRecordVO.setSettleBalanceMny(sumSettleTaxMny.subtract(settleTaxMny));
        return finishRecordVO;
    }

    @Override
    public FinishVO queryDetailAdd(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        FinishVO finishVO = (FinishVO)BeanMapper.map((Object)((Object)contractEntity), FinishVO.class);
        finishVO.setBillCode(null);
        finishVO.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        finishVO.setEmployeeName(null);
        finishVO.setContractId(contractEntity.getId());
        finishVO.setBillState(null);
        finishVO.setCreateUserCode(null);
        finishVO.setCreateTime(null);
        finishVO.setUpdateUserCode(null);
        finishVO.setUpdateTime(null);
        finishVO.setId(null);
        finishVO.setVersion(null);
        finishVO.setTaxMny(null);
        finishVO.setSumInvoiceTaxMny(null);
        finishVO.setContractVersion(contractEntity.getVersion());
        return finishVO;
    }

    @Override
    public List<FinishVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = ((IPage)this.queryListVOs(param).getData()).getRecords();
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                FinishVO vo = (FinishVO)resVos.get(i);
                if (vo.getContractType() != null) {
                    if (vo.getContractType().equals(Long.valueOf("1270328729526124545"))) {
                        vo.setContractTypeName("\u4e13\u4e1a\u5206\u5305");
                    } else if (vo.getContractType().equals(Long.valueOf("1270328674299723778"))) {
                        vo.setContractTypeName("\u52b3\u52a1\u5206\u5305");
                    }
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public CommonResponse<FinishVO> pushCost(FinishVO finishVO) {
        BigDecimal shouldPayTaxMny;
        List finishCostList;
        BigDecimal money;
        FinishEntity finishEntity = (FinishEntity)((Object)((FinishMapper)this.baseMapper).selectById(finishVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)finishVO.getFinishCostList()) && (money = (finishCostList = finishVO.getFinishCostList()).stream().map(FinishCostVO::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(shouldPayTaxMny = finishEntity.getShouldPayTaxMny()) != 0) {
            throw new BusinessException("\u7ed3\u7b97\u5dee\u989d\u548c\u6210\u672c\u660e\u7ec6\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        if (CollectionUtils.isNotEmpty((Collection)finishVO.getFinishCostList())) {
            List costEntities = BeanMapper.mapList((Iterable)finishVO.getFinishCostList(), FinishCostEntity.class);
            finishEntity.setFinishCostList(costEntities);
        }
        super.saveOrUpdate((Object)finishEntity, false);
        this.costPush(finishEntity);
        return CommonResponse.success((Object)this.queryDetail(finishVO.getId()));
    }

    @Override
    public void costPush(FinishEntity finishEntity) {
        Boolean isPush = true;
        LambdaQueryWrapper costWrapper = new LambdaQueryWrapper();
        costWrapper.eq(FinishCostEntity::getFinishId, (Object)finishEntity.getId());
        List costEntities = this.finishCostService.list((Wrapper)costWrapper);
        if (CollectionUtils.isEmpty((Collection)costEntities)) {
            isPush = false;
        } else if (isPush.booleanValue()) {
            BigDecimal totalMny = BigDecimal.ZERO;
            for (FinishCostEntity costEntity : costEntities) {
                if (null == costEntity.getSubjectId()) {
                    isPush = false;
                    break;
                }
                BigDecimal money = null != costEntity.getMoney() ? costEntity.getMoney() : BigDecimal.ZERO;
                totalMny = totalMny.add(money);
            }
            if (null == finishEntity.getShouldPayTaxMny() || totalMny.compareTo(finishEntity.getShouldPayTaxMny()) != 0) {
                isPush = false;
            }
        }
        finishEntity.setFinishCostList(costEntities);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)finishEntity.getId());
        updateWrapper.set(FinishEntity::getRelationFlag, (Object)(isPush != false ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = finishEntity.getRelationFlag();
        if (oldRelationFlag.equals("1")) {
            if (isPush.booleanValue()) {
                this.saveCost(finishEntity);
            }
            if (!isPush.booleanValue()) {
                this.costDetailApi.deleteSubject(finishEntity.getId());
            }
        }
        if (oldRelationFlag.equals("0")) {
            this.saveCost(finishEntity);
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(FinishEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal settleTaxMny, BigDecimal contractTaxMny, Long orgId) {
        Long curOrgId = Optional.ofNullable(orgId).orElse(InvocationInfoProxy.getOrgId());
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, curOrgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            for (BillParamVO datum : data) {
                BigDecimal roleValue = datum.getRoleValue();
                BigDecimal comMny = contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100L), 2, 4));
                if (2 == purchaseType) {
                    paramsCheckVO.setWarnType(paramsArray[0]);
                    return paramsCheckVO;
                }
                paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                if (settleTaxMny.compareTo(comMny) <= 0) continue;
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setOrgName(datum.getOrgName());
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u5b8c\u5de5\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(settleTaxMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue.setScale(2, 4)).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(settleTaxMny.subtract(comMny).setScale(2, 4)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
                FinishServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    private void saveCost(FinishEntity finishEntity) {
        BigDecimal taxRate = finishEntity.getTaxRate().divide(new BigDecimal(100));
        BigDecimal number = taxRate.add(new BigDecimal(1));
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<FinishCostEntity> finishCostList = finishEntity.getFinishCostList();
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(finishEntity.getContractId()));
        Long contractType = contractEntity.getContractType();
        String contractTypeName = "";
        Integer costType = null;
        String sourceType = "SUB_FINISH_PRO";
        if (contractType.equals(1270328729526124545L)) {
            sourceType = "SUB_FINISH_LAB";
            contractTypeName = CostTypeEnum.LABOR_COST_TYPE.getName();
            costType = CostTypeEnum.LABOR_COST_TYPE.getType();
        } else {
            contractTypeName = CostTypeEnum.MAJOR_COST_TYPE.getName();
            costType = CostTypeEnum.MAJOR_COST_TYPE.getType();
        }
        String period = "";
        if (finishEntity.getSettleDate() != null) {
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM");
            period = ft.format(finishEntity.getSettleDate());
        }
        this.logger.info("----------------------------finishCostList:" + finishCostList.size());
        if (CollectionUtils.isNotEmpty(finishCostList) && finishCostList.size() > 0) {
            for (FinishCostEntity costEntity : finishCostList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(costEntity.getSubjectId());
                costDetailVO.setSourceId(costEntity.getFinishId());
                costDetailVO.setSourceDetailId(costEntity.getId());
                costDetailVO.setHappenTaxMny(costEntity.getMoney());
                BigDecimal pushSettlementMny = costEntity.getMoney();
                BigDecimal happenMny = pushSettlementMny.divide(number, 2, 4);
                costDetailVO.setHappenMny(happenMny);
                costDetailVO.setHappenDate(finishEntity.getSettleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(sourceType);
                costDetailVO.setSourceTabType(SUB_FINISH_COST);
                costDetailVO.setProjectId(finishEntity.getProjectId());
                costDetailVO.setCostType(costType);
                costDetailVO.setCostTypeName(contractTypeName);
                costDetailVO.setPeriod(period);
                costDetailVO.setShareFlag(Integer.valueOf(0));
                costDetailVO.setSourceBillCode(finishEntity.getBillCode());
                costDetailVO.setSourceBillName(finishEntity.getContractName());
                costDetailVO.setSourceBillUrl("/ejc-sub-frontend/#/finish/card?id=" + finishEntity.getId());
                costDetailVOList.add(costDetailVO);
            }
        } else {
            this.logger.info("---------------------------------------------\u5b50\u8868\u6210\u672c\u5206\u644a\u9875\u7b7e\u6570\u636e\u4e3a\u7a7a\uff0c\u63a8\u9001\u4e3b\u8868-----------------------");
            CostDetailVO costDetailVO = new CostDetailVO();
            costDetailVO.setSourceId(finishEntity.getId());
            costDetailVO.setHappenTaxMny(finishEntity.getShouldPayTaxMny());
            costDetailVO.setHappenMny(finishEntity.getShouldPayMny());
            costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
            costDetailVO.setSourceType(sourceType);
            costDetailVO.setProjectId(finishEntity.getProjectId());
            costDetailVO.setCostType(costType);
            costDetailVO.setCostTypeName(contractTypeName);
            costDetailVO.setPeriod(period);
            costDetailVO.setShareFlag(Integer.valueOf(0));
            costDetailVO.setSourceBillCode(finishEntity.getBillCode());
            costDetailVO.setSourceBillName(finishEntity.getContractName());
            costDetailVO.setSourceBillUrl("/ejc-sub-frontend/#/finish/card?id=" + finishEntity.getId());
            costDetailVOList.add(costDetailVO);
        }
        if (CollectionUtils.isNotEmpty(costDetailVOList)) {
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("----------------------\u5b8c\u5de5\u7ed3\u7b97\u63a8\u9001\u7ed3\u679c\uff1a" + stringCommonResponse.isSuccess());
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    private void writeBackContractFinsishFlag(FinishEntity finishEntity, Boolean finishFlag) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getContractStatus, (Object)(finishFlag != false ? "3" : "2"));
        updateWrapper.set(ContractEntity::getFinishFlag, (Object)finishFlag);
        updateWrapper.eq(BaseEntity::getId, (Object)finishEntity.getContractId());
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(finishEntity.getContractId()));
        this.contractService.update((Object)contractEntity, (Wrapper)updateWrapper, false);
    }
}

