package com.ejianc.business.sub.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.vo.*;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface IContractService extends IBaseService<ContractEntity> {
    ContractVO insertOrUpdate(ContractVO contractVO);

    ContractVO queryDetail(Long id, Boolean detailHasChildren);

    CommonResponse<String> deleteByIds(List<ContractVO> ids);

    CommonResponse<IPage<ContractVO>> queryListVOs(QueryParam param);

    Map<String, Object> countContractAmount(QueryParam param);

    ContractVO queryRecordDetail(Long id, boolean b);

    List<ContractDetailVO> refContractDetail(Long contractId, String condition);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    List<Map<String, Object>> payMnyWarn(List<SqlParam> sqlParamList);

    List<Map<String, Object>> prePayMnyWarn(List<SqlParam> sqlParamList);

    List<Map<String, Object>> finishMnyWarn(List<SqlParam> sqlParamList);

    List<Map<String, Object>> invoicePayMnyWarn(List<SqlParam> sqlParamList);

    List<Map<String, Object>> invoiceContractMnyWarn(List<SqlParam> sqlParamList);

    List<SubWarnVo> subProjectOutMny(List<Long> tenantIds);

    List<SubProjectReportVo> getMonthSubMny(Long projectId, Integer lastDay);

    SubProjectReportVo getSubContract(Long projectId);

    List<SubProjectSettleNumVO> getSubSettleNum(List<Long> projectIds);

    ParamsCheckVO checkParams(ContractVO vo);

    ParamsCheckVO checkParamsDetail(ContractVO vo);

    BigDecimal fetchSjzcje(Long projectId);

    /**
     * @return {@link PicketageVO}
     *
     * @description: 根据定标单回写已签合同数量和金额
     * @author songlx
     * @date: 2023/11/8
     */
    PicketageVO countContractNumAndMnyByEnquiry(Long... enquiryPriceBillIds);

}
