/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.vo.FinishRecordVO;
import com.ejianc.business.sub.vo.FinishVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"finish"})
public class FinishController
implements Serializable {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IFinishService finishService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FinishVO> saveOrUpdate(@RequestBody FinishVO finishVO) {
        FinishVO vo = this.finishService.insertOrUpdate(finishVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinishVO> queryDetail(Long id) {
        FinishVO vo = this.finishService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        CommonResponse<FinishVO> response = this.queryDetail(id);
        FinishVO finishVO = (FinishVO)response.getData();
        finishVO.setFinishDetail(finishVO.getFinishDetailList());
        finishVO.setPaidMoney(ComputeUtil.nullToZero((BigDecimal)finishVO.getPaidMoney()));
        finishVO.setUnPaidMoney(ComputeUtil.nullToZero((BigDecimal)finishVO.getUnPaidMoney()));
        JSONObject vo = (JSONObject)JSONObject.toJSON((Object)finishVO);
        Long contractId = finishVO.getContractId();
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(contractId));
        vo.put("contractId", (Object)contractEntity);
        json.put("Finish", (Object)vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FinishVO>> queryList(@RequestBody QueryParam param) {
        return this.finishService.queryListVOs(param);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinishVO> vos) {
        return this.finishService.deleteByIds(vos);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinishRecordVO> queryDetailRecord(Long id) {
        FinishRecordVO vo = this.finishService.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8bb0\u5f55\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailAdd"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinishVO> queryDetailAdd(Long contractId) {
        FinishVO vo = this.finishService.queryDetailAdd(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u67e5\u8be2\u5408\u540c\u8f6c\u5316\u4e3a\u5b8c\u5de5\u7ed3\u7b97\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<FinishVO> list = this.finishService.queryExportList(queryParam);
        HashMap<String, List<FinishVO>> beans = new HashMap<String, List<FinishVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("sub-finish-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FinishVO> pushCost(@RequestBody FinishVO finishVO) {
        return this.finishService.pushCost(finishVO);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestParam(value="purchaseType") Integer purchaseType, @RequestParam(value="settleTaxMny") BigDecimal settleTaxMny, @RequestParam(value="contractTaxMny") BigDecimal contractTaxMny, @RequestParam(value="orgId") Long orgId) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.finishService.checkParams(purchaseType, settleTaxMny, contractTaxMny, orgId));
    }
}

