/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contract"})
public class ContractApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService service;
    @Autowired
    private ISettleService settleService;

    @GetMapping(value={"fetchSjzcje"})
    public CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((Object)this.service.fetchSjzcje(projectId));
    }

    @PostMapping(value={"getContractByCondition"})
    @ResponseBody
    public CommonResponse<List<ContractVO>> getContractByCondition(@RequestBody List<Long> enquiryPriceBillIds) {
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        lambdaUpdateWrapper.in(ContractEntity::getEnquiryPriceBillId, enquiryPriceBillIds);
        lambdaUpdateWrapper.orderByDesc(ContractEntity::getSignDate);
        List list = this.service.list((Wrapper)lambdaUpdateWrapper);
        return CommonResponse.success((Object)BeanMapper.mapList((Iterable)list, ContractVO.class));
    }

    @GetMapping(value={"getSettleVO"})
    public CommonResponse<SettleVO> getSettleVO(@RequestParam(value="settleId") Long settleId) {
        return CommonResponse.success((Object)this.settleService.queryDetail(settleId, true));
    }
}

