/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.FinishEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/subForPay/"})
public class SubContractForPayApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IContractService service;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IFinishService finishService;

    @GetMapping(value={"updateSubContractSumPayMny"})
    public CommonResponse<String> updateSubContractSumPayMny(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="payMny") BigDecimal payMny, @RequestParam(value="prepayMny") BigDecimal prepayMny) {
        ContractEntity entity = (ContractEntity)((Object)this.service.getById(contractId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u5206\u5305\u5408\u540c\uff01");
        }
        BigDecimal sumPayMny = entity.getSumPayMny();
        sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)payMny);
        entity.setSumPayMny(sumPayMny);
        BigDecimal sumPrepayMny = entity.getSumPrepayMny();
        sumPrepayMny = MathUtil.safeAdd((BigDecimal)sumPrepayMny, (BigDecimal)prepayMny);
        entity.setSumPrepayMny(sumPrepayMny);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u56de\u5199\u5206\u5305\u5408\u540c\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u3001\u7d2f\u8ba1\u9884\u4ed8\u6b3e\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"updateSubSettleSumPayMny"})
    public CommonResponse<String> updateSubSettleSumPayMny(@RequestParam(value="settleId", required=true) Long settleId, @RequestParam(value="payMny") BigDecimal payMny) {
        SettleEntity settle = (SettleEntity)((Object)this.settleService.getById(settleId));
        FinishEntity finish = (FinishEntity)((Object)this.finishService.getById(settleId));
        if (settle != null) {
            BigDecimal sumPayMny = settle.getSumPayMny();
            sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)payMny);
            settle.setSumPayMny(sumPayMny);
            this.settleService.saveOrUpdate((Object)settle, false);
            return CommonResponse.success((String)"\u56de\u5199\u5206\u5305\u7ed3\u7b97\u5355\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u6210\u529f\uff01");
        }
        if (finish != null) {
            BigDecimal sumPayMny = finish.getSumPayMny();
            sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)payMny);
            finish.setSumPayMny(sumPayMny);
            this.finishService.saveOrUpdate((Object)finish, false);
            return CommonResponse.success((String)"\u56de\u5199\u5206\u5305\u7ed3\u7b97\u5355\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u5206\u5305\u7ed3\u7b97\u5355\uff01");
    }

    @GetMapping(value={"updateSubSettleSumApplyMny"})
    public CommonResponse<String> updateSubSettleSumApplyMny(@RequestParam(value="settleId", required=true) Long settleId, @RequestParam(value="applyMny") BigDecimal applyMny) {
        SettleEntity settle = (SettleEntity)((Object)this.settleService.getById(settleId));
        FinishEntity finish = (FinishEntity)((Object)this.finishService.getById(settleId));
        if (settle != null) {
            BigDecimal sumApplyMny = settle.getSumApplyMny();
            sumApplyMny = MathUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)applyMny);
            settle.setSumApplyMny(sumApplyMny);
            BigDecimal surplusApplyMny = MathUtil.safeSub((BigDecimal)MathUtil.safeSub((BigDecimal)settle.getSettleTaxMny(), (BigDecimal)settle.getOffsetMny()), (BigDecimal)sumApplyMny);
            settle.setSurplusApplyMny(surplusApplyMny);
            this.settleService.saveOrUpdate((Object)settle, false);
            return CommonResponse.success((String)"\u56de\u5199\u5206\u5305\u7ed3\u7b97\u5355\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u3001\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d\u6210\u529f\uff01");
        }
        if (finish != null) {
            BigDecimal sumApplyMny = finish.getSumApplyMny();
            sumApplyMny = MathUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)applyMny);
            finish.setSumApplyMny(sumApplyMny);
            BigDecimal surplusApplyMny = MathUtil.safeSub((BigDecimal)finish.getSettleTaxMny(), (BigDecimal)sumApplyMny);
            finish.setSurplusApplyMny(surplusApplyMny);
            this.finishService.saveOrUpdate((Object)finish, false);
            return CommonResponse.success((String)"\u56de\u5199\u5b8c\u5de5\u7ed3\u7b97\u5355\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\u3001\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u5206\u5305\u7ed3\u7b97\u5355\uff01");
    }

    @GetMapping(value={"getSubSettleById"})
    public CommonResponse<SubSettleVO> getSubSettleById(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="orgId", required=true) Long orgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.eq(SettleEntity::getContractId, (Object)contractId);
        wrapper.eq(SettleEntity::getOrgId, (Object)orgId);
        wrapper.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.settleService.list((Wrapper)wrapper);
        BigDecimal sumOffsetMny = null;
        for (SettleEntity entity : list) {
            sumOffsetMny = MathUtil.safeAdd(sumOffsetMny, (BigDecimal)entity.getOffsetMny());
        }
        SubSettleVO vo = new SubSettleVO();
        vo.setContractId(contractId);
        vo.setOrgId(orgId);
        vo.setSumOffsetMny(sumOffsetMny);
        return CommonResponse.success((String)"\u83b7\u53d6\u4fe1\u606f\u6210\u529f", (Object)vo);
    }
}

