package com.ejianc.business.supbid.other.api;

import com.ejianc.business.supbid.notice.vo.FileVO;
import com.ejianc.business.supbid.notice.vo.NoticeVO;
import com.ejianc.business.supbid.notice.vo.SignVO;
import com.ejianc.business.supbid.notice.vo.SupOfferVO;
import com.ejianc.business.supbid.other.hystrix.SupNoticeHystrix;
import com.ejianc.business.supbid.win.vo.BidVO;
import com.ejianc.business.supbid.win.vo.WinVO;
import com.ejianc.business.supbid.winbid.vo.WinbidVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;


/**
 * 供方接口
 */
@FeignClient(name = "ejc-supbid-web", url = "${common.env.feign-client-url}", path = "ejc-supbid-web", fallback = SupNoticeHystrix.class)
public interface ISupNoticeApi {
    //发布公告推送接口
    @PostMapping(value = "/api/notice/saveOrUpdate")
    CommonResponse<Boolean> saveOrUpdate(@RequestBody NoticeVO saveorUpdateVO);

    //招标文件推送接口
    @PostMapping(value = "/api/notice/saveWj")
    CommonResponse<Boolean> saveWj(@RequestBody NoticeVO saveorUpdateVO);

    //答疑附件上传接口
    @PostMapping(value = "/api/notice/addFile")
    CommonResponse<Boolean> addFile(FileVO fileVO);

    //答疑附件删除接口
    @PostMapping(value = "/api/notice/delFile")
    CommonResponse<String> delFile(@RequestBody FileVO vo);

    //延长截止时间接口
    @PostMapping(value = "/api/notice/updateTime")
    CommonResponse<Boolean> updateTime(@RequestBody NoticeVO saveorUpdateVO);
    //供应商补充报价接口
    @PostMapping(value = "/api/notice/updateSupOffer")
    CommonResponse<Boolean> updateSupOffer(@RequestBody List<SupOfferVO> supOfferList);

    //供应商淘汰接口
    @PostMapping(value = "/api/notice/updateSupStatus")
    CommonResponse<Boolean> updateSupStatus(@RequestBody List<SignVO> signVOList);

    //流标/废标 供应商淘汰接口
    @PostMapping(value = "/api/notice/updateBidOut")
    CommonResponse<Boolean> updateBidOut(@RequestBody SupOfferVO supOfferVO);

    //中标通知书接收接口
    @PostMapping(value = "/api/notice/saveBid")
    CommonResponse<Boolean> saveBid(@RequestBody BidVO bidVO);

    //中标公告同步服务
    @PostMapping(value = "/api/notice/saveWin")
    CommonResponse<Boolean> saveWin(@RequestBody WinVO saveOrUpdateVO);

    //定标、流标、废标通知接口
    @PostMapping(value = "/api/notice/winbidSave")
    CommonResponse<Boolean> winbidSave(@RequestBody List<WinbidVO> listVO);
}
