package com.ejianc.business.supbusiness.proequipment.settlement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 设备租赁-临时租赁结算明细
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁-临时租赁结算明细")
public class TemporarySettlementDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("结算主键ID")
    private Long settlementId;
    @ApiModelProperty("来源主键ID")
    private Long sourceId;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("来源类型名称(记录—100231)")
    private String sourceName;
    @ApiModelProperty("来源类型（0-记录，1-合同）")
    private Integer sourceType;
    @ApiModelProperty("来源编码")
    private String sourceCode;
    @ApiModelProperty("设备类别")
    private Long equipmentTypeId;
    @ApiModelProperty("设备类别名称")
    private String equipmentTypeName;
    @ApiModelProperty("设备主键")
    private Long equipmentId;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("设备编码")
    private String equipmentCode;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("单位id")
    private Long unitId;
    @ApiModelProperty("计租方式id")
    private Long rentTypeId;
    @ApiModelProperty("计租方式名称")
    private String rentType;
    @ApiModelProperty("开始日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;
    @ApiModelProperty("结束日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;
    @ApiModelProperty("租赁数量")
    private BigDecimal rentNum;
    @ApiModelProperty("租赁单价(无税)")
    private BigDecimal rentPrice;
    @ApiModelProperty("租赁单价")
    private BigDecimal rentTaxPrice;
    @ApiModelProperty("租赁金额(无税)")
    private BigDecimal rentMny;
    @ApiModelProperty("租赁金额)")
    private BigDecimal rentTaxMny;
    @ApiModelProperty("租赁税率")
    private BigDecimal rentTaxRate;
    @ApiModelProperty("租赁税额")
    private BigDecimal rentTax;
    @ApiModelProperty("使用数量")
    private BigDecimal num;
    @ApiModelProperty("结算单价(无税)")
    private BigDecimal price;
    @ApiModelProperty("结算单价)")
    private BigDecimal taxPrice;
    @ApiModelProperty("结算金额(无税)")
    private BigDecimal mny;
    @ApiModelProperty("结算金额")
    private BigDecimal taxMny;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("核算对象主键")
    private Long wbsId;
    @ApiModelProperty("核算对象编码")
    private String wbsCode;
    @ApiModelProperty("核算对象名称")
    private String wbsName;
    @ApiModelProperty("成本科目主键")
    private Long subjectId;
    @ApiModelProperty("成本科目编码")
    private String subjectCode;
    @ApiModelProperty("成本科目名称")
    private String subjectName;
    

    /**
     * 结算主键ID
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * 结算主键ID
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    /**
     * 来源主键ID
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键ID
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源明细主键ID
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源明细主键ID
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 来源类型名称(记录—100231)
     */
    public String getSourceName() {
        return sourceName;
    }

    /**
     * 来源类型名称(记录—100231)
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
    /**
     * 来源类型（0-记录，1-合同）
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型（0-记录，1-合同）
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源编码
     */
    public String getSourceCode() {
        return sourceCode;
    }

    /**
     * 来源编码
     */
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    /**
     * 设备类别
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 设备类别
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    /**
     * 设备类别名称
     */
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    /**
     * 设备类别名称
     */
    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    /**
     * 设备主键
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备主键
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 设备编码
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编码
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计租方式id
     */
    public Long getRentTypeId() {
        return rentTypeId;
    }

    /**
     * 计租方式id
     */
    public void setRentTypeId(Long rentTypeId) {
        this.rentTypeId = rentTypeId;
    }
    /**
     * 计租方式名称
     */
    public String getRentType() {
        return rentType;
    }

    /**
     * 计租方式名称
     */
    public void setRentType(String rentType) {
        this.rentType = rentType;
    }
    /**
     * 开始日期
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * 开始日期
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 结束日期
     */
    public Date getEndDate() {
        return endDate;
    }

    /**
     * 结束日期
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 租赁数量
     */
    public BigDecimal getRentNum() {
        return rentNum;
    }

    /**
     * 租赁数量
     */
    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }
    /**
     * 租赁单价(无税)
     */
    public BigDecimal getRentPrice() {
        return rentPrice;
    }

    /**
     * 租赁单价(无税)
     */
    public void setRentPrice(BigDecimal rentPrice) {
        this.rentPrice = rentPrice;
    }
    /**
     * 租赁单价
     */
    public BigDecimal getRentTaxPrice() {
        return rentTaxPrice;
    }

    /**
     * 租赁单价
     */
    public void setRentTaxPrice(BigDecimal rentTaxPrice) {
        this.rentTaxPrice = rentTaxPrice;
    }
    /**
     * 租赁金额(无税)
     */
    public BigDecimal getRentMny() {
        return rentMny;
    }

    /**
     * 租赁金额(无税)
     */
    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }
    /**
     * 租赁金额)
     */
    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    /**
     * 租赁金额)
     */
    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }
    /**
     * 租赁税率
     */
    public BigDecimal getRentTaxRate() {
        return rentTaxRate;
    }

    /**
     * 租赁税率
     */
    public void setRentTaxRate(BigDecimal rentTaxRate) {
        this.rentTaxRate = rentTaxRate;
    }
    /**
     * 租赁税额
     */
    public BigDecimal getRentTax() {
        return rentTax;
    }

    /**
     * 租赁税额
     */
    public void setRentTax(BigDecimal rentTax) {
        this.rentTax = rentTax;
    }
    /**
     * 使用数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 使用数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 结算单价(无税)
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 结算单价(无税)
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 结算单价)
     */
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    /**
     * 结算单价)
     */
    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    /**
     * 结算金额(无税)
     */
    public BigDecimal getMny() {
        return mny;
    }

    /**
     * 结算金额(无税)
     */
    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 结算金额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 结算金额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 税额
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税额
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 核算对象主键
     */
    public Long getWbsId() {
        return wbsId;
    }

    /**
     * 核算对象主键
     */
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    /**
     * 核算对象编码
     */
    public String getWbsCode() {
        return wbsCode;
    }

    /**
     * 核算对象编码
     */
    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }
    /**
     * 核算对象名称
     */
    public String getWbsName() {
        return wbsName;
    }

    /**
     * 核算对象名称
     */
    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    /**
     * 成本科目主键
     */
    public Long getSubjectId() {
        return subjectId;
    }

    /**
     * 成本科目主键
     */
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    /**
     * 成本科目编码
     */
    public String getSubjectCode() {
        return subjectCode;
    }

    /**
     * 成本科目编码
     */
    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    /**
     * 成本科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 成本科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    
}
