package com.ejianc.business.supbusiness.promaterial.order.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 消耗材订单表
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材订单表")
public class MaterialOrderVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("来源订单主键")
    private Long sourceId;
    @ApiModelProperty("来源系统主键")
    private String systemId;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("提交人")
    private Long commitId;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("上级组织")
    private Long parentOrgId;
    @ApiModelProperty("上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("合同主键")
    private String contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门Id")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("联系人")
    private Long linkId;
    @ApiModelProperty("联系人名称")
    private String linkName;
    @ApiModelProperty("联系人电话")
    private String linkTelephone;
    @ApiModelProperty("订单日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date orderCreateDate;
    @ApiModelProperty("到货日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date orderExpiryDate;
    @ApiModelProperty("施工部位")
    private String construction;
    @ApiModelProperty("送货要求")
    private String orderNote;
    @ApiModelProperty("送货地址")
    private String orderAddress;
    @ApiModelProperty("接收状态（0-待接收,1-部分接收，2-全部接收，3-不予接收）")
    private Integer receiveState;
    @ApiModelProperty("发货状态（0-待送货，1-部分送货，2-已送货）")
    private Integer deliverState;
    @ApiModelProperty("是否开启订单 0-正常，1-已关闭")
    private Integer orderFlag;
    @ApiModelProperty("合同采购编码")
    private String contractPropertyCode;
    @ApiModelProperty("合同采购（属性）名称")
    private String contractPropertyName;

    @ApiModelProperty("不予接收原因")
    private String receiveReason;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("设备供应商")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;

    private Integer automaticWeigh; //自动称重设置（0：自动称重，1非自动称重）

    @ApiModelProperty("消耗材订单明细表")
    private List<MaterialOrderDetailVO> materialOrderDetailList = new ArrayList<>();
    @ApiModelProperty("送货单明细")
    private List<MaterialDeliveryVO> materialDeliveryList = new ArrayList<>();

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    /**
     * 来源订单主键
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源订单主键
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源系统主键
     */
    public String getSystemId() {
        return systemId;
    }

    /**
     * 来源系统主键
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 提交人
     */
    public Long getCommitId() {
        return commitId;
    }

    /**
     * 提交人
     */
    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 上级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 上级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    public String getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门Id
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门Id
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 联系人
     */
    public Long getLinkId() {
        return linkId;
    }

    /**
     * 联系人
     */
    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }
    /**
     * 联系人名称
     */
    public String getLinkName() {
        return linkName;
    }

    /**
     * 联系人名称
     */
    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    /**
     * 联系人电话
     */
    public String getLinkTelephone() {
        return linkTelephone;
    }

    /**
     * 联系人电话
     */
    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    /**
     * 订单日期
     */
    public Date getOrderCreateDate() {
        return orderCreateDate;
    }

    /**
     * 订单日期
     */
    public void setOrderCreateDate(Date orderCreateDate) {
        this.orderCreateDate = orderCreateDate;
    }
    /**
     * 到货日期
     */
    public Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    /**
     * 到货日期
     */
    public void setOrderExpiryDate(Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }
    /**
     * 施工部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 送货要求
     */
    public String getOrderNote() {
        return orderNote;
    }

    /**
     * 送货要求
     */
    public void setOrderNote(String orderNote) {
        this.orderNote = orderNote;
    }
    /**
     * 送货地址
     */
    public String getOrderAddress() {
        return orderAddress;
    }

    /**
     * 送货地址
     */
    public void setOrderAddress(String orderAddress) {
        this.orderAddress = orderAddress;
    }
    /**
     * 接收状态（0-待接收,1-部分接收，2-全部接收，3-不予接收）
     */
    public Integer getReceiveState() {
        return receiveState;
    }

    /**
     * 接收状态（0-待接收,1-部分接收，2-全部接收，3-不予接收）
     */
    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }
    /**
     * 发货状态（0-待送货，1-部分送货，2-已送货）
     */
    public Integer getDeliverState() {
        return deliverState;
    }

    /**
     * 发货状态（0-待送货，1-部分送货，2-已送货）
     */
    public void setDeliverState(Integer deliverState) {
        this.deliverState = deliverState;
    }
    /**
     * 是否开启订单 0-正常，1-已关闭
     */
    public Integer getOrderFlag() {
        return orderFlag;
    }

    /**
     * 是否开启订单 0-正常，1-已关闭
     */
    public void setOrderFlag(Integer orderFlag) {
        this.orderFlag = orderFlag;
    }
    /**
     * 合同采购编码
     */
    public String getContractPropertyCode() {
        return contractPropertyCode;
    }

    /**
     * 合同采购编码
     */
    public void setContractPropertyCode(String contractPropertyCode) {
        this.contractPropertyCode = contractPropertyCode;
    }
    /**
     * 合同采购（属性）名称
     */
    public String getContractPropertyName() {
        return contractPropertyName;
    }

    /**
     * 合同采购（属性）名称
     */
    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }

    public String getReceiveReason() {
        return receiveReason;
    }

    public void setReceiveReason(String receiveReason) {
        this.receiveReason = receiveReason;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    /**
      * 消耗材订单明细表
      */
      public List<MaterialOrderDetailVO> getMaterialOrderDetailList() {
         return materialOrderDetailList;
      }
     /**
      * 消耗材订单明细表
      */
     public void setMaterialOrderDetailList(List<MaterialOrderDetailVO> materialOrderDetailList) {
         this.materialOrderDetailList = materialOrderDetailList;
     }

    public List<MaterialDeliveryVO> getMaterialDeliveryList() {
        return materialDeliveryList;
    }

    public void setMaterialDeliveryList(List<MaterialDeliveryVO> materialDeliveryList) {
        this.materialDeliveryList = materialDeliveryList;
    }
}
