package com.ejianc.business.supbusiness.promaterial.out.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.supbusiness.promaterial.out.vo.OutStoreSubVO;

/**
 * 消耗材-领料出库
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材-领料出库")
public class OutStoreVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("出库单号")
    private String billCode;
    @ApiModelProperty("领料日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate;
    @ApiModelProperty("出库仓库id")
    private Long storeId;
    @ApiModelProperty("出库仓库名称")
    private String storeName;
    @ApiModelProperty("出库物资名称集合")
    private String materialNames;
    @ApiModelProperty("出库数量")
    private BigDecimal outNum;
    @ApiModelProperty("出库金额")
    private BigDecimal outMny;
    @ApiModelProperty("出库金额含税")
    private BigDecimal outTaxMny;
    @ApiModelProperty("用处")
    private String useFor;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目id")
    private Long projectId;
    @ApiModelProperty("所属项目编码")
    private String projectCode;
    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("合同id")
    private Long subContractId;
    @ApiModelProperty("合同名称")
    private String subContractName;
    @ApiModelProperty("分包单位")
    private String subSupplierName;
    @ApiModelProperty("供应商id")
    private Long subSupplierId;
    @ApiModelProperty("分包负责人")
    private String subEmployeeName;
    @ApiModelProperty("分包负责人电话")
    private String subEmployeeMobile;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("")
    private String supOperatorUserCode;
    @ApiModelProperty("")
    private String supOperatorPhone;
    @ApiModelProperty("")
    private String supOperatorName;
    @ApiModelProperty("")
    private Date supOperateTime;
    @ApiModelProperty("签字状态，0-未签字,1-已签字")
    private Integer signStatus;
    @ApiModelProperty("来源订单主键")
    private Long sourceId;
    @ApiModelProperty("来源系统主键")
    private String systemId;
    
    @ApiModelProperty("消耗材-领料出库明细")
    private List<OutStoreSubVO> outStoreSubList = new ArrayList<>();

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 出库单号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 出库单号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 领料日期
     */
    public Date getOutDate() {
        return outDate;
    }

    /**
     * 领料日期
     */
    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    /**
     * 出库仓库id
     */
    public Long getStoreId() {
        return storeId;
    }

    /**
     * 出库仓库id
     */
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    /**
     * 出库仓库名称
     */
    public String getStoreName() {
        return storeName;
    }

    /**
     * 出库仓库名称
     */
    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    /**
     * 出库物资名称集合
     */
    public String getMaterialNames() {
        return materialNames;
    }

    /**
     * 出库物资名称集合
     */
    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    /**
     * 出库数量
     */
    public BigDecimal getOutNum() {
        return outNum;
    }

    /**
     * 出库数量
     */
    public void setOutNum(BigDecimal outNum) {
        this.outNum = outNum;
    }
    /**
     * 出库金额
     */
    public BigDecimal getOutMny() {
        return outMny;
    }

    /**
     * 出库金额
     */
    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    /**
     * 出库金额含税
     */
    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    /**
     * 出库金额含税
     */
    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }
    /**
     * 用处
     */
    public String getUseFor() {
        return useFor;
    }

    /**
     * 用处
     */
    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 经办人id
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 所属项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 所属项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同id
     */
    public Long getSubContractId() {
        return subContractId;
    }

    /**
     * 合同id
     */
    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }
    /**
     * 合同名称
     */
    public String getSubContractName() {
        return subContractName;
    }

    /**
     * 合同名称
     */
    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }
    /**
     * 分包单位
     */
    public String getSubSupplierName() {
        return subSupplierName;
    }

    /**
     * 分包单位
     */
    public void setSubSupplierName(String subSupplierName) {
        this.subSupplierName = subSupplierName;
    }
    /**
     * 供应商id
     */
    public Long getSubSupplierId() {
        return subSupplierId;
    }

    /**
     * 供应商id
     */
    public void setSubSupplierId(Long subSupplierId) {
        this.subSupplierId = subSupplierId;
    }
    /**
     * 分包负责人
     */
    public String getSubEmployeeName() {
        return subEmployeeName;
    }

    /**
     * 分包负责人
     */
    public void setSubEmployeeName(String subEmployeeName) {
        this.subEmployeeName = subEmployeeName;
    }
    /**
     * 分包负责人电话
     */
    public String getSubEmployeeMobile() {
        return subEmployeeMobile;
    }

    /**
     * 分包负责人电话
     */
    public void setSubEmployeeMobile(String subEmployeeMobile) {
        this.subEmployeeMobile = subEmployeeMobile;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同code
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同code
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 
     */
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    /**
     * 
     */
    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    /**
     * 
     */
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    /**
     * 
     */
    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    /**
     * 
     */
    public String getSupOperatorName() {
        return supOperatorName;
    }

    /**
     * 
     */
    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    /**
     * 
     */
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    /**
     * 
     */
    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    /**
     * 签字状态，0-未签字,1-已签字
     */
    public Integer getSignStatus() {
        return signStatus;
    }

    /**
     * 签字状态，0-未签字,1-已签字
     */
    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    /**
     * 来源订单主键
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源订单主键
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源系统主键
     */
    public String getSystemId() {
        return systemId;
    }

    /**
     * 来源系统主键
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    
     /**
      * 消耗材-领料出库明细
      */
      public List<OutStoreSubVO> getOutStoreSubList() {
         return outStoreSubList;
      }
     /**
      * 消耗材-领料出库明细
      */
     public void setOutStoreSubList(List<OutStoreSubVO> outStoreSubList) {
         this.outStoreSubList = outStoreSubList;
     }
}
