package com.ejianc.business.supbusiness.promaterial.settlement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.supbusiness.promaterial.settlement.vo.SettlementDetailVO;
import com.ejianc.business.supbusiness.promaterial.settlement.vo.SettlementFeeVO;
import com.ejianc.business.supbusiness.promaterial.settlement.vo.SettlementCollectVO;

/**
 * 消耗材（混凝土）结算表
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材（混凝土）结算表")
public class SettlementVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("供应商")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("结算日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date settlementDate;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("合同采购编码")
    private String contractPropertyCode;
    @ApiModelProperty("合同采购（属性）名称")
    private String contractPropertyName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章")
    private Integer signatureStatus;
    @ApiModelProperty("签字状态，0-未签字,1-已签字")
    private Integer signStatus;
    @ApiModelProperty("结算类型，0-过程,1-最终")
    private Integer signatureType;
    @ApiModelProperty("结算金额(无税)")
    private BigDecimal settlementMny;
    @ApiModelProperty("结算金额")
    private BigDecimal settlementTaxMny;
    @ApiModelProperty("结算税额")
    private BigDecimal settlementTax;
    @ApiModelProperty("材料金额(无税)")
    private BigDecimal materialMny;
    @ApiModelProperty("材料金额")
    private BigDecimal materialTaxMny;
    @ApiModelProperty("材料税额")
    private BigDecimal materialTax;
    @ApiModelProperty("其他金额(无税)")
    private BigDecimal feeMny;
    @ApiModelProperty("其他金额")
    private BigDecimal feeTaxMny;
    @ApiModelProperty("其他税额")
    private BigDecimal feeTax;
    @ApiModelProperty("合同金额")
    private BigDecimal contractTaxMny;
    @ApiModelProperty("合同收票金额")
    private BigDecimal contractInvoiceTaxMny;
    @ApiModelProperty("合同已付金额")
    private BigDecimal contractPayMny;
    @ApiModelProperty("含本期结算金额")
    private BigDecimal currentSettlementTaxMny;
    @ApiModelProperty("结算单类型（0-物资采购结算单，1-混凝土结算单）")
    private Integer settlementType;

    @ApiModelProperty("来源结算单主键")
    private Long sourceId;
    @ApiModelProperty("来源系统主键")
    private String systemId;

    /**
     * 供方经办人名称
     */
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;

    @ApiModelProperty("消耗材（混凝土）结算明细表")
    private List<SettlementDetailVO> settlementDetailList = new ArrayList<>();
    @ApiModelProperty("消耗材（混凝土）结算其他费用表")
    private List<SettlementFeeVO> settlementFeeList = new ArrayList<>();
    @ApiModelProperty("消耗材（混凝土）结算明细汇总表")
    private List<SettlementCollectVO> settlementCollectList = new ArrayList<>();

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 结算日期
     */
    public Date getSettlementDate() {
        return settlementDate;
    }

    /**
     * 结算日期
     */
    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 合同采购编码
     */
    public String getContractPropertyCode() {
        return contractPropertyCode;
    }

    /**
     * 合同采购编码
     */
    public void setContractPropertyCode(String contractPropertyCode) {
        this.contractPropertyCode = contractPropertyCode;
    }
    /**
     * 合同采购（属性）名称
     */
    public String getContractPropertyName() {
        return contractPropertyName;
    }

    /**
     * 合同采购（属性）名称
     */
    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    /**
     * 签字状态，0-未签字,1-已签字
     */
    public Integer getSignStatus() {
        return signStatus;
    }

    /**
     * 签字状态，0-未签字,1-已签字
     */
    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    /**
     * 结算类型，0-过程,1-最终
     */
    public Integer getSignatureType() {
        return signatureType;
    }

    /**
     * 结算类型，0-过程,1-最终
     */
    public void setSignatureType(Integer signatureType) {
        this.signatureType = signatureType;
    }
    /**
     * 结算金额(无税)
     */
    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    /**
     * 结算金额(无税)
     */
    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    /**
     * 结算金额
     */
    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    /**
     * 结算金额
     */
    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }
    /**
     * 结算税额
     */
    public BigDecimal getSettlementTax() {
        return settlementTax;
    }

    /**
     * 结算税额
     */
    public void setSettlementTax(BigDecimal settlementTax) {
        this.settlementTax = settlementTax;
    }
    /**
     * 材料金额(无税)
     */
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    /**
     * 材料金额(无税)
     */
    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    /**
     * 材料金额
     */
    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    /**
     * 材料金额
     */
    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }
    /**
     * 材料税额
     */
    public BigDecimal getMaterialTax() {
        return materialTax;
    }

    /**
     * 材料税额
     */
    public void setMaterialTax(BigDecimal materialTax) {
        this.materialTax = materialTax;
    }
    /**
     * 其他金额(无税)
     */
    public BigDecimal getFeeMny() {
        return feeMny;
    }

    /**
     * 其他金额(无税)
     */
    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }
    /**
     * 其他金额
     */
    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    /**
     * 其他金额
     */
    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }
    /**
     * 其他税额
     */
    public BigDecimal getFeeTax() {
        return feeTax;
    }

    /**
     * 其他税额
     */
    public void setFeeTax(BigDecimal feeTax) {
        this.feeTax = feeTax;
    }
    /**
     * 合同金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同收票金额
     */
    public BigDecimal getContractInvoiceTaxMny() {
        return contractInvoiceTaxMny;
    }

    /**
     * 合同收票金额
     */
    public void setContractInvoiceTaxMny(BigDecimal contractInvoiceTaxMny) {
        this.contractInvoiceTaxMny = contractInvoiceTaxMny;
    }
    /**
     * 合同已付金额
     */
    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    /**
     * 合同已付金额
     */
    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }
    /**
     * 含本期结算金额
     */
    public BigDecimal getCurrentSettlementTaxMny() {
        return currentSettlementTaxMny;
    }

    /**
     * 含本期结算金额
     */
    public void setCurrentSettlementTaxMny(BigDecimal currentSettlementTaxMny) {
        this.currentSettlementTaxMny = currentSettlementTaxMny;
    }
    /**
     * 结算单类型（0-物资采购结算单，1-混凝土结算单）
     */
    public Integer getSettlementType() {
        return settlementType;
    }

    /**
     * 结算单类型（0-物资采购结算单，1-混凝土结算单）
     */
    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }
    
     /**
      * 消耗材（混凝土）结算明细表
      */
      public List<SettlementDetailVO> getSettlementDetailList() {
         return settlementDetailList;
      }
     /**
      * 消耗材（混凝土）结算明细表
      */
     public void setSettlementDetailList(List<SettlementDetailVO> settlementDetailList) {
         this.settlementDetailList = settlementDetailList;
     }
     /**
      * 消耗材（混凝土）结算其他费用表
      */
      public List<SettlementFeeVO> getSettlementFeeList() {
         return settlementFeeList;
      }
     /**
      * 消耗材（混凝土）结算其他费用表
      */
     public void setSettlementFeeList(List<SettlementFeeVO> settlementFeeList) {
         this.settlementFeeList = settlementFeeList;
     }
     /**
      * 消耗材（混凝土）结算明细汇总表
      */
      public List<SettlementCollectVO> getSettlementCollectList() {
         return settlementCollectList;
      }
     /**
      * 消耗材（混凝土）结算明细汇总表
      */
     public void setSettlementCollectList(List<SettlementCollectVO> settlementCollectList) {
         this.settlementCollectList = settlementCollectList;
     }
}
