package com.ejianc.business.supbusiness.prosub.process.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 专业分包领料结算
 *
 * @author generator
 *
 */
public class PicKingVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    private Integer supplementFlag; // 合同类别：0-主合同 1-补充协议
    private Long projectId; // 项目Id
    private String projectName; // 项目名称（带入）
    private String projectCode; // 项目编号
    private String employeeName; // 申请人名 即经办人
    private Long employeeId; // 申请人id 即经办人
    private Long departmentId; // 经办部门id
    private String departmentName; // 经办部门
    private Long firstPartyId;// 甲方Id
    private String firstPartyName;// 甲方名称
    private Integer supplierSignStatus; // 乙方签字状态:已签字-1,未签字-0
    private Long supplierId; // 乙方id
    private String supplierName; // 乙方名称
    private Long orgId; // 项目组织ID
    private String orgName; // 项目组织名称
    private String parentOrgCode; // 组织编码
    private String parentOrgName; // 组织名称
    private Long parentOrgId; // 组织id
    private String memo; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期：默认显示当天
    private BigDecimal mny; // 本期扣款金额(无税)
    private BigDecimal taxMny; // 本期扣款金额(含税)
    private BigDecimal tax; // 本期扣款税额
    private BigDecimal outMny; //  出库结算金额(无税)
    private BigDecimal outTaxMny; // 出库结算金额（含税）
    private BigDecimal outTax; // 出库结算税额
    private BigDecimal exitTax; // 退库税额
    private BigDecimal exitMny; // 退库金额（无税）
    private BigDecimal exitTaxMny; // 退库金额（含税）
    private Date commitData; // 提交日期
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String billCode; // 编码
    private Long contractCategoryId; // 合同类别
    private String contractCategoryName; // 合同类别 名称
    private String contractCategoryCode; // 合同类别 编码
    private BigDecimal equipmentDeductTax; // '设备扣款税额'
    private BigDecimal equipmentDeductMny; // 设备扣款金额（无税）
    private BigDecimal equipmentDeductTaxMny; // 设备扣款金额（含税）

    /**
     * 单据状态名称
     */
    private String billStateName;
    private List<PickingEquipmentVO> equipmentList = new ArrayList<>();//领料汇总子表
    private List<PicKingStoreVO> outList = new ArrayList<>(); // 出库子表
    private List<PicKingStoreVO> exitList = new ArrayList<>();//退库子表
    private List<PicKingTotalVO> totalList = new ArrayList<>();//领料汇总子表

    public List<PickingEquipmentVO> getEquipmentList() {
        return equipmentList;
    }

    public void setEquipmentList(List<PickingEquipmentVO> equipmentList) {
        this.equipmentList = equipmentList;
    }

    /**
     * 制单人Id
     */
    private Long createUserId;

    /***  协同需要字段 START  ***/

    /**
     * 供方经办人名称
     */
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    private Long supOperateFileId;

    /**
     * 来源业务单据Id
     */
    private String sourceId;

    /**
     * 来源业务系统id
     */
    private String sourceSystemId;

    /***  协同需要字段 END  ***/




    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }


    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }

    /***  协同需要字段 END  ***/




    public List<PicKingStoreVO> getOutList() {
        return outList;
    }

    public void setOutList(List<PicKingStoreVO> outList) {
        this.outList = outList;
    }

    public List<PicKingStoreVO> getExitList() {
        return exitList;
    }

    public void setExitList(List<PicKingStoreVO> exitList) {
        this.exitList = exitList;
    }

    public List<PicKingTotalVO> getTotalList() {
        return totalList;
    }

    public void setTotalList(List<PicKingTotalVO> totalList) {
        this.totalList = totalList;
    }

    public BigDecimal getEquipmentDeductTax() {
        return equipmentDeductTax;
    }

    public void setEquipmentDeductTax(BigDecimal equipmentDeductTax) {
        this.equipmentDeductTax = equipmentDeductTax;
    }

    public BigDecimal getEquipmentDeductMny() {
        return equipmentDeductMny;
    }

    public void setEquipmentDeductMny(BigDecimal equipmentDeductMny) {
        this.equipmentDeductMny = equipmentDeductMny;
    }

    public BigDecimal getEquipmentDeductTaxMny() {
        return equipmentDeductTaxMny;
    }

    public void setEquipmentDeductTaxMny(BigDecimal equipmentDeductTaxMny) {
        this.equipmentDeductTaxMny = equipmentDeductTaxMny;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public String getContractCategoryCode() {
        return contractCategoryCode;
    }

    public void setContractCategoryCode(String contractCategoryCode) {
        this.contractCategoryCode = contractCategoryCode;
    }

    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }
    public BigDecimal getOutTax() {
        return outTax;
    }

    public void setOutTax(BigDecimal outTax) {
        this.outTax = outTax;
    }
    public BigDecimal getExitTax() {
        return exitTax;
    }

    public void setExitTax(BigDecimal exitTax) {
        this.exitTax = exitTax;
    }
    public BigDecimal getExitMny() {
        return exitMny;
    }

    public void setExitMny(BigDecimal exitMny) {
        this.exitMny = exitMny;
    }
    public BigDecimal getExitTaxMny() {
        return exitTaxMny;
    }

    public void setExitTaxMny(BigDecimal exitTaxMny) {
        this.exitTaxMny = exitTaxMny;
    }
    public Date getCommitData() {
        return commitData;
    }

    public void setCommitData(Date commitData) {
        this.commitData = commitData;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }


    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
