package com.ejianc.business.supbusiness.proequipment.start.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.supbusiness.proequipment.check.vo.RentAcceptanceDetailVO;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 设备租赁-设备退场
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁-设备退场")
public class EquipmentAppearanceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目id")
    private Long projectId;
    @ApiModelProperty("所属单位")
    private String projectOrg;
    @ApiModelProperty("所属单位id")
    private Long projectOrgId;
    @ApiModelProperty("供应商")
    private String supplierName;
    @ApiModelProperty("供应商id")
    private Long supplierId;
    @ApiModelProperty("出场日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date appearanceDate;
    @ApiModelProperty("止租日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rentEndDate;
    @ApiModelProperty("经办人")
    private String employee;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("现场照片路径")
    private String photoPath;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("项目部ID")
    private Long projectDepartmentId;
    @ApiModelProperty("项目部名称")
    private String projectDepartmentName;
    @ApiModelProperty("提交日期")
    private Date commitDate;
    @ApiModelProperty("提交人名称")
    private String commitUserName;
    @ApiModelProperty("提交人账号")
    private String commitUserCode;
    @ApiModelProperty("是否签字")
    private Integer notSignature;
    @ApiModelProperty("项目方签字")
    private String projectMangerSign;
    @ApiModelProperty("供应商签字")
    private String supplierSign;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方")
    private String billPushFlag;
    @ApiModelProperty("")
    private String supOperatorUserCode;
    @ApiModelProperty("")
    private String supOperatorPhone;
    @ApiModelProperty("")
    private String supOperatorName;
    @ApiModelProperty("")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;
    @ApiModelProperty("来源订单主键")
    private Long sourceId;
    @ApiModelProperty("来源系统主键")
    private String systemId;
    @ApiModelProperty("乙方签字状态:已签字-1,未签字-0")
    private Integer supplierSignStatus;

    @ApiModelProperty("设备租赁-设备退场细表")
    List<EquipmentAppearanceDetailVO> appearanceSubList = new ArrayList<>();
    

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 所属单位
     */
    public String getProjectOrg() {
        return projectOrg;
    }

    /**
     * 所属单位
     */
    public void setProjectOrg(String projectOrg) {
        this.projectOrg = projectOrg;
    }
    /**
     * 所属单位id
     */
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    /**
     * 所属单位id
     */
    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    /**
     * 供应商
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供应商id
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 出场日期
     */
    public Date getAppearanceDate() {
        return appearanceDate;
    }

    /**
     * 出场日期
     */
    public void setAppearanceDate(Date appearanceDate) {
        this.appearanceDate = appearanceDate;
    }
    /**
     * 止租日期
     */
    public Date getRentEndDate() {
        return rentEndDate;
    }

    /**
     * 止租日期
     */
    public void setRentEndDate(Date rentEndDate) {
        this.rentEndDate = rentEndDate;
    }
    /**
     * 经办人
     */
    public String getEmployee() {
        return employee;
    }

    /**
     * 经办人
     */
    public void setEmployee(String employee) {
        this.employee = employee;
    }
    /**
     * 经办人id
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 现场照片路径
     */
    public String getPhotoPath() {
        return photoPath;
    }

    /**
     * 现场照片路径
     */
    public void setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 项目部ID
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部ID
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 项目部名称
     */
    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    /**
     * 项目部名称
     */
    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }
    /**
     * 提交日期
     */
    public Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 提交人名称
     */
    public String getCommitUserName() {
        return commitUserName;
    }

    /**
     * 提交人名称
     */
    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    /**
     * 提交人账号
     */
    public String getCommitUserCode() {
        return commitUserCode;
    }

    /**
     * 提交人账号
     */
    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    /**
     * 是否签字
     */
    public Integer getNotSignature() {
        return notSignature;
    }

    /**
     * 是否签字
     */
    public void setNotSignature(Integer notSignature) {
        this.notSignature = notSignature;
    }
    /**
     * 项目方签字
     */
    public String getProjectMangerSign() {
        return projectMangerSign;
    }

    /**
     * 项目方签字
     */
    public void setProjectMangerSign(String projectMangerSign) {
        this.projectMangerSign = projectMangerSign;
    }
    /**
     * 供应商签字
     */
    public String getSupplierSign() {
        return supplierSign;
    }

    /**
     * 供应商签字
     */
    public void setSupplierSign(String supplierSign) {
        this.supplierSign = supplierSign;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    public String getBillPushFlag() {
        return billPushFlag;
    }

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }
    /**
     * 
     */
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    /**
     * 
     */
    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    /**
     * 
     */
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    /**
     * 
     */
    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    /**
     * 
     */
    public String getSupOperatorName() {
        return supOperatorName;
    }

    /**
     * 
     */
    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    /**
     * 
     */
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    /**
     * 
     */
    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    /**
     * 来源订单主键
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源订单主键
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源系统主键
     */
    public String getSystemId() {
        return systemId;
    }

    /**
     * 来源系统主键
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    /**
     * 乙方签字状态:已签字-1,未签字-0
     */
    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    /**
     * 乙方签字状态:已签字-1,未签字-0
     */
    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }


    public List<EquipmentAppearanceDetailVO> getAppearanceSubList() {
        return appearanceSubList;
    }

    public void setAppearanceSubList(List<EquipmentAppearanceDetailVO> appearanceSubList) {
        this.appearanceSubList = appearanceSubList;
    }
}
