package com.ejianc.business.supbusiness.prormat.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 验收单
 * 
 * @author generator
 * 
 */
public class CheckVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orderId; // 订单主键
    private Long deliveryId; // 发货主键
    private String deliveryBillCode; // 送货单单据编号
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private String contractRmatMethod; // 合同租赁方式
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private Long supplierId; // 设备供应商
    private String supplierName; // 供应商名称
    private Long firstPartyId; // 甲方Id
    private String firstPartyName; // 甲方名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 验收日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rmatDate; // 计租日期
    private String licensePlate; // 车牌号
    private String memo; // 备注
    private String checkSource; // 验收来源(0-自制，1-送货单)
    private String checkSourceName; // 验收来源(送货单单据编号或自制)
    private Integer supplierSignStatus; // 供方签字状态:已签字-1,未签字-0



    /**
     * 制单人Id
     */
    private Long createUserId;

    /***  协同需要字段 START  ***/

    /**
     * 供方经办人名称
     */
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    private Long supOperateFileId;

    /**
     * 来源业务单据Id
     */
    private String sourceId;

    /**
     * 来源业务系统id
     */
    private String sourceSystemId;

    /***  协同需要字段 END  ***/


    private List<CheckDetailVO> checkDetailList = new ArrayList<>(); // 验收单明细

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    public String getDeliveryBillCode() {
        return deliveryBillCode;
    }

    public void setDeliveryBillCode(String deliveryBillCode) {
        this.deliveryBillCode = deliveryBillCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }


    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }


    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractRmatMethod() {
        return contractRmatMethod;
    }

    public void setContractRmatMethod(String contractRmatMethod) {
        this.contractRmatMethod = contractRmatMethod;
    }


    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }


    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }


    public String getSupplierName() {
        return supplierName;
    }
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }


    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public Date getRmatDate() {
        return rmatDate;
    }

    public void setRmatDate(Date rmatDate) {
        this.rmatDate = rmatDate;
    }
    public String getLicensePlate() {
        return licensePlate;
    }

    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getCheckSource() {
        return checkSource;
    }

    public void setCheckSource(String checkSource) {
        this.checkSource = checkSource;
    }
    public List<CheckDetailVO> getCheckDetailList() {
        return checkDetailList;
     }

     public void setCheckDetailList(List<CheckDetailVO> checkDetailList) {
        this.checkDetailList = checkDetailList;
     }

    public String getCheckSourceName() {
        return checkSourceName;
    }

    public void setCheckSourceName(String checkSourceName) {
        this.checkSourceName = checkSourceName;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }


    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
}
