package com.ejianc.business.supbusiness.promaterial.order.vo;

import java.math.*;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 消耗材订单明细表
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材订单明细表")
public class MaterialOrderDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("序号")
    private String detailIndex;
    @ApiModelProperty("parent_id")
    private Long parentId;
    @ApiModelProperty("订单主键ID")
    private Long orderId;
    @ApiModelProperty("施工部位")
    private String construction;
    @ApiModelProperty("物资主键")
    private Long materialId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资类别")
    private Long materialTypeId;
    @ApiModelProperty("物资类别名称")
    private String materialTypeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("单位id")
    private Long unitId;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("接收数量")
    private BigDecimal receiveNumsSum;
    @ApiModelProperty("订单数量")
    private BigDecimal orderNumsSum;
    @ApiModelProperty("发货数量")
    private BigDecimal deliverNumsSum;
    @ApiModelProperty("未发货数量")
    private BigDecimal notShippedNumSum;
    @ApiModelProperty("生产厂家")
    private String materialManufacturer;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("树形主键")
    private Long tid;
    @ApiModelProperty("（无税）单价")
    private BigDecimal price;
    @ApiModelProperty("（含税）单价")
    private BigDecimal taxPrice;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    private Integer detailAutomaticWeigh; //自动称重设置（0：自动称重，1非自动称重）

    public Integer getDetailAutomaticWeigh() {
        return detailAutomaticWeigh;
    }

    public void setDetailAutomaticWeigh(Integer detailAutomaticWeigh) {
        this.detailAutomaticWeigh = detailAutomaticWeigh;
    }

    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * parent_id
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * parent_id
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 订单主键ID
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键ID
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 施工部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 接收数量
     */
    public BigDecimal getReceiveNumsSum() {
        return receiveNumsSum;
    }

    /**
     * 接收数量
     */
    public void setReceiveNumsSum(BigDecimal receiveNumsSum) {
        this.receiveNumsSum = receiveNumsSum;
    }
    /**
     * 订单数量
     */
    public BigDecimal getOrderNumsSum() {
        return orderNumsSum;
    }

    /**
     * 订单数量
     */
    public void setOrderNumsSum(BigDecimal orderNumsSum) {
        this.orderNumsSum = orderNumsSum;
    }
    /**
     * 发货数量
     */
    public BigDecimal getDeliverNumsSum() {
        return deliverNumsSum;
    }

    /**
     * 发货数量
     */
    public void setDeliverNumsSum(BigDecimal deliverNumsSum) {
        this.deliverNumsSum = deliverNumsSum;
    }
    /**
     * 未发货数量
     */
    public BigDecimal getNotShippedNumSum() {
        return notShippedNumSum;
    }

    /**
     * 未发货数量
     */
    public void setNotShippedNumSum(BigDecimal notShippedNumSum) {
        this.notShippedNumSum = notShippedNumSum;
    }
    /**
     * 生产厂家
     */
    public String getMaterialManufacturer() {
        return materialManufacturer;
    }

    /**
     * 生产厂家
     */
    public void setMaterialManufacturer(String materialManufacturer) {
        this.materialManufacturer = materialManufacturer;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 树形主键
     */
    public Long getTid() {
        return tid;
    }

    /**
     * 树形主键
     */
    public void setTid(Long tid) {
        this.tid = tid;
    }
    /**
     * （无税）单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * （无税）单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * （含税）单价
     */
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    /**
     * （含税）单价
     */
    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    
}
