package com.ejianc.business.supbusiness.prosub.settle.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 结算子表-分包清单
 *
 * @author generator
 */
public class SettleDetailVO extends BaseVO {
    private static final long serialVersionUID = -343008117695006153L;

    private Integer useFlag; // 是否引用过,否-0，是-1
    private Long settleId; // 结算id
    private Long contractId; // 合同id
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    private Integer settleType; // 结算类型：0-过程，1-完工，2-节点
    private Long projectId; // 项目Id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    private String sourceType; // 来源:合同，分包计量
    private Long sourceId; // 来源id
    private Long sourceBillId; // 来源主单据id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sourceBillDate; // 来源主单据日期
    private String sourceBillCode; // 来源主单据编号
    private Long contractDetailId; // 合同清单id
    private Long docId; // 档案id
    private Long docCategoryId; // 档案分类id
    private String detailName; // 清单名称
    private String detailMeasurementRules; // 工作计量规则
    private String detailWorkContent; // 工作内容
    private String detailUnit; // 单位
    private BigDecimal detailNum; // 合同量
    private BigDecimal totalProcessNum; // 含本期累计过程结算量：取该清单在已生效过程结算单中累计结算量+本期结算量；如果有多行对应合同同一个清单，本期结算量是多行的累计值
    private BigDecimal lastProcessNum; // 历史过程结算量：该清单在已生效过程结算单中累计结算量
    private BigDecimal totalNodeNum; // 累计节点结算量：取该清单在已生效的节点结算单中累计结算量+本期结算量
    private BigDecimal lastNodeNum; // 历史节点结算量：该清单在已生效节点结算单中累计结算量
    private BigDecimal settleNum; // 本期结算量：=累计节点结算量—过程累计结算量
    private BigDecimal detailTaxPrice; // 单价(含税)
    private BigDecimal detailPrice; // 单价(无税)
    private BigDecimal detailTaxRate; // 税率
    private BigDecimal settleTaxMny; // 本期结算金额
    private BigDecimal settleMny; // 本期结算金额(无税)
    private BigDecimal settleTax; // 本期结算税额
    private BigDecimal processTaxDifference; // 过程结算差额
    private BigDecimal processDifference; // 过程结算差额（无税）
    private BigDecimal nodeTaxDifference; // 节点结算差额
    private BigDecimal nodeDifference; // 节点结算差额（无税）
    private String memo; // 备注
    private Long parentId;


    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSourceBillId() {
        return sourceBillId;
    }

    public void setSourceBillId(Long sourceBillId) {
        this.sourceBillId = sourceBillId;
    }

    public Date getSourceBillDate() {
        return sourceBillDate;
    }

    public void setSourceBillDate(Date sourceBillDate) {
        this.sourceBillDate = sourceBillDate;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    public Long getDocCategoryId() {
        return docCategoryId;
    }

    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    public String getDetailWorkContent() {
        return detailWorkContent;
    }

    public void setDetailWorkContent(String detailWorkContent) {
        this.detailWorkContent = detailWorkContent;
    }

    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }

    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }

    public BigDecimal getTotalProcessNum() {
        return totalProcessNum;
    }

    public void setTotalProcessNum(BigDecimal totalProcessNum) {
        this.totalProcessNum = totalProcessNum;
    }

    public BigDecimal getLastProcessNum() {
        return lastProcessNum;
    }

    public void setLastProcessNum(BigDecimal lastProcessNum) {
        this.lastProcessNum = lastProcessNum;
    }

    public BigDecimal getTotalNodeNum() {
        return totalNodeNum;
    }

    public void setTotalNodeNum(BigDecimal totalNodeNum) {
        this.totalNodeNum = totalNodeNum;
    }

    public BigDecimal getLastNodeNum() {
        return lastNodeNum;
    }

    public void setLastNodeNum(BigDecimal lastNodeNum) {
        this.lastNodeNum = lastNodeNum;
    }

    public BigDecimal getSettleNum() {
        return settleNum;
    }

    public void setSettleNum(BigDecimal settleNum) {
        this.settleNum = settleNum;
    }

    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }

    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }

    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getSettleTax() {
        return settleTax;
    }

    public void setSettleTax(BigDecimal settleTax) {
        this.settleTax = settleTax;
    }

    public BigDecimal getProcessTaxDifference() {
        return processTaxDifference;
    }

    public void setProcessTaxDifference(BigDecimal processTaxDifference) {
        this.processTaxDifference = processTaxDifference;
    }

    public BigDecimal getProcessDifference() {
        return processDifference;
    }

    public void setProcessDifference(BigDecimal processDifference) {
        this.processDifference = processDifference;
    }

    public BigDecimal getNodeTaxDifference() {
        return nodeTaxDifference;
    }

    public void setNodeTaxDifference(BigDecimal nodeTaxDifference) {
        this.nodeTaxDifference = nodeTaxDifference;
    }

    public BigDecimal getNodeDifference() {
        return nodeDifference;
    }

    public void setNodeDifference(BigDecimal nodeDifference) {
        this.nodeDifference = nodeDifference;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

}
