package com.ejianc.business.supbusiness.assistmaterial.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单据类型编码常量
 */
public enum BillTypeEnum {

    租赁订单("租赁订单", "EJCBT202205000002"),
    验收单("验收单", "EJCBT202204000000005"),
    辅料中心采购合同("辅料中心采购合同", "EJCBT202204001000006"),
    辅料中心采购合同变更("辅料中心采购合同变更", "EJCBT202204001000007"),
    辅料中心采购合同记录("辅料中心采购合同记录", "EJCBT202204001000008"),
    租金计算单("租金计算单", "BT220322000000008"),
    辅料中心采购合同解除("辅料中心采购合同解除", "EJCBT202204000000009"),
    辅料中心采购合同冻结("辅料中心采购合同冻结", "EJCBT202204001000010"),
    辅料中心采购合同结算单("辅料中心采购合同结算单", "EJCBT202204000000011"),
    ;

    private final String name;
    private final String code;
    private static Map<String, BillTypeEnum> enumMap = new HashMap();

    private BillTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static BillTypeEnum getEnumByName(String billTypeName) {
        return (BillTypeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(BillTypeEnum.class).stream().collect(Collectors.toMap(BillTypeEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
