package com.ejianc.business.supbusiness.assistrmat.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 周转材租赁-送货单
 * 
 * @author generator
 * 
 */
public class DeliveryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orderId; // 订单主键
    private String orderBillCode; // 订单单据编号
    private String billCode; // 单据编码
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private String contractRmatMethod; // 合同租赁方式
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private Long supplierId; // 设备供应商
    private String supplierName; // 供应商名称
    private Long firstPartyId; // 甲方Id
    private String firstPartyName; // 甲方名称
    private Long deliveryManId; // 送货人
    private String deliveryManName; // 送货人名称
    private String deliveryManTelephone; // 送货人电话
    private String deliveryCarNumber; // 车牌号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date orderExpectDate; // 预计到货日期
    private String memo; // 备注
    private String acceptanceState; // 验收状态(0-未验收，1-已验收)
    private String disableState; // 是否关闭(1-是，0-否)

    private String billStateName; // 单据状态（审批必须字段）

    /***  协同需要字段 START  ***/
    private String supOperatorName; // 供方经办人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date supOperateTime; // 供方经办人签字时间
    private String supOperatorPhone; // 供方经办人手机号
    private String supOperatorUserCode; // 供方经办人账号
    private Long supOperateFileId;// 供方经办人签字文件id
    private String sourceSystemId;// 来源业务系统id
    /***  协同需要字段 END  ***/

    private Long linkId; // 联系人
    private String linkName; // 联系人名称
    private String linkTelephone; // 联系人电话
    private String orderSourceSystemId;// 来源业务系统id

    private List<DeliveryDetailVO> deliveryDetailList = new ArrayList<>(); // 周转材租赁-送货单明细

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public String getOrderBillCode() {
        return orderBillCode;
    }

    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractRmatMethod() {
        return contractRmatMethod;
    }

    public void setContractRmatMethod(String contractRmatMethod) {
        this.contractRmatMethod = contractRmatMethod;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getDeliveryManId() {
        return deliveryManId;
    }
    @ReferDeserialTransfer
    public void setDeliveryManId(Long deliveryManId) {
        this.deliveryManId = deliveryManId;
    }

    public String getDeliveryManName() {
        return deliveryManName;
    }

    public void setDeliveryManName(String deliveryManName) {
        this.deliveryManName = deliveryManName;
    }
    public String getDeliveryManTelephone() {
        return deliveryManTelephone;
    }

    public void setDeliveryManTelephone(String deliveryManTelephone) {
        this.deliveryManTelephone = deliveryManTelephone;
    }
    public String getDeliveryCarNumber() {
        return deliveryCarNumber;
    }

    public void setDeliveryCarNumber(String deliveryCarNumber) {
        this.deliveryCarNumber = deliveryCarNumber;
    }
    public Date getOrderExpectDate() {
        return orderExpectDate;
    }

    public void setOrderExpectDate(Date orderExpectDate) {
        this.orderExpectDate = orderExpectDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getAcceptanceState() {
        return acceptanceState;
    }

    public void setAcceptanceState(String acceptanceState) {
        this.acceptanceState = acceptanceState;
    }
    public String getDisableState() {
        return disableState;
    }

    public void setDisableState(String disableState) {
        this.disableState = disableState;
    }

     public List<DeliveryDetailVO> getDeliveryDetailList() {
        return deliveryDetailList;
     }

     public void setDeliveryDetailList(List<DeliveryDetailVO> deliveryDetailList) {
        this.deliveryDetailList = deliveryDetailList;
     }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }


    public Long getLinkId() {
        return linkId;
    }

    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }

    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    public String getLinkTelephone() {
        return linkTelephone;
    }

    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }

    public String getOrderSourceSystemId() {
        return orderSourceSystemId;
    }

    public void setOrderSourceSystemId(String orderSourceSystemId) {
        this.orderSourceSystemId = orderSourceSystemId;
    }
}
