package com.ejianc.business.supbusiness.proequipment.check.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 设备租赁-验收明细表
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁-验收明细表")
public class RentAcceptanceDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String code;
    @ApiModelProperty("费用项目名称")
    private String name;
    @ApiModelProperty("单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    @ApiModelProperty("规格型号")
    private String specs;
    @ApiModelProperty("租凭方式")
    private String rentMode;
    @ApiModelProperty("设备出场编号")
    private String equipmentAppearanceCode;
    @ApiModelProperty("验收结果:1-合格,2-不合格")
    private Integer acceptanceResult;
    @ApiModelProperty("验收结果")
    private String acceptanceResultName;
    @ApiModelProperty("启动时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;
    @ApiModelProperty("出厂日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date appearanceDate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("主表id")
    private Long pid;
    @ApiModelProperty("设备分类id")
    private Long categoryId;
    @ApiModelProperty("设备分类")
    private String categoryName;
    @ApiModelProperty("设备编号")
    private String equipmentCode;
    @ApiModelProperty("设备id")
    private Long equipmentId;
    @ApiModelProperty("数量")
    private Integer num;
    @ApiModelProperty("租赁方式id:1--日租,2--月租,3--工程量")
    private Integer rentTypeId;
    @ApiModelProperty("租赁方式名称")
    private String rentTypeName;
    @ApiModelProperty("租赁金额")
    private BigDecimal price;
    @ApiModelProperty("无税租赁金额")
    private BigDecimal notTaxPrice;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("计划进场日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planIntoDate;
    @ApiModelProperty("计划出场日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planOutDate;
    @ApiModelProperty("生成厂家")
    private String productionManufactor;
    @ApiModelProperty("单位name")
    private String unitName;
    @ApiModelProperty("单位id")
    private Long unitId;
    @ApiModelProperty("设备出厂编号")
    private String factoryCode;
    @ApiModelProperty("计租日期")
    private Date meterRentDate;
    @ApiModelProperty("工程数量")
    private Integer quantitiesNum;
    @ApiModelProperty("来源id")
    private Long sourceId;
    @ApiModelProperty("发货主键ID")
    private Long deliveryId;
    @ApiModelProperty("发货明细主键ID")
    private Long deliveryDetailId;
    @ApiModelProperty("订单主键ID")
    private Long orderId;
    @ApiModelProperty("订单明细主键ID")
    private Long orderDetailId;

    private Long  sourceDetailId;

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 费用项目名称
     */
    public String getName() {
        return name;
    }

    /**
     * 费用项目名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 规格型号
     */
    public String getSpecs() {
        return specs;
    }

    /**
     * 规格型号
     */
    public void setSpecs(String specs) {
        this.specs = specs;
    }
    /**
     * 租凭方式
     */
    public String getRentMode() {
        return rentMode;
    }

    /**
     * 租凭方式
     */
    public void setRentMode(String rentMode) {
        this.rentMode = rentMode;
    }
    /**
     * 设备出场编号
     */
    public String getEquipmentAppearanceCode() {
        return equipmentAppearanceCode;
    }

    /**
     * 设备出场编号
     */
    public void setEquipmentAppearanceCode(String equipmentAppearanceCode) {
        this.equipmentAppearanceCode = equipmentAppearanceCode;
    }
    /**
     * 验收结果:1-合格,2-不合格
     */
    public Integer getAcceptanceResult() {
        return acceptanceResult;
    }

    /**
     * 验收结果:1-合格,2-不合格
     */
    public void setAcceptanceResult(Integer acceptanceResult) {
        this.acceptanceResult = acceptanceResult;
    }
    /**
     * 验收结果
     */
    public String getAcceptanceResultName() {
        return acceptanceResultName;
    }

    /**
     * 验收结果
     */
    public void setAcceptanceResultName(String acceptanceResultName) {
        this.acceptanceResultName = acceptanceResultName;
    }
    /**
     * 启动时间
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * 启动时间
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 出厂日期
     */
    public Date getAppearanceDate() {
        return appearanceDate;
    }

    /**
     * 出厂日期
     */
    public void setAppearanceDate(Date appearanceDate) {
        this.appearanceDate = appearanceDate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 主表id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 主表id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }
    /**
     * 设备分类id
     */
    public Long getCategoryId() {
        return categoryId;
    }

    /**
     * 设备分类id
     */
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    /**
     * 设备分类
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 设备分类
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    /**
     * 设备编号
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编号
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 设备id
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备id
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 数量
     */
    public Integer getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(Integer num) {
        this.num = num;
    }
    /**
     * 租赁方式id:1--日租,2--月租,3--工程量
     */
    public Integer getRentTypeId() {
        return rentTypeId;
    }

    /**
     * 租赁方式id:1--日租,2--月租,3--工程量
     */
    public void setRentTypeId(Integer rentTypeId) {
        this.rentTypeId = rentTypeId;
    }
    /**
     * 租赁方式名称
     */
    public String getRentTypeName() {
        return rentTypeName;
    }

    /**
     * 租赁方式名称
     */
    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }
    /**
     * 租赁金额
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 租赁金额
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 无税租赁金额
     */
    public BigDecimal getNotTaxPrice() {
        return notTaxPrice;
    }

    /**
     * 无税租赁金额
     */
    public void setNotTaxPrice(BigDecimal notTaxPrice) {
        this.notTaxPrice = notTaxPrice;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 计划进场日期
     */
    public Date getPlanIntoDate() {
        return planIntoDate;
    }

    /**
     * 计划进场日期
     */
    public void setPlanIntoDate(Date planIntoDate) {
        this.planIntoDate = planIntoDate;
    }
    /**
     * 计划出场日期
     */
    public Date getPlanOutDate() {
        return planOutDate;
    }

    /**
     * 计划出场日期
     */
    public void setPlanOutDate(Date planOutDate) {
        this.planOutDate = planOutDate;
    }
    /**
     * 生成厂家
     */
    public String getProductionManufactor() {
        return productionManufactor;
    }

    /**
     * 生成厂家
     */
    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    /**
     * 单位name
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 单位name
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 设备出厂编号
     */
    public String getFactoryCode() {
        return factoryCode;
    }

    /**
     * 设备出厂编号
     */
    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode;
    }
    /**
     * 计租日期
     */
    public Date getMeterRentDate() {
        return meterRentDate;
    }

    /**
     * 计租日期
     */
    public void setMeterRentDate(Date meterRentDate) {
        this.meterRentDate = meterRentDate;
    }
    /**
     * 工程数量
     */
    public Integer getQuantitiesNum() {
        return quantitiesNum;
    }

    /**
     * 工程数量
     */
    public void setQuantitiesNum(Integer quantitiesNum) {
        this.quantitiesNum = quantitiesNum;
    }
    /**
     * 来源id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 发货主键ID
     */
    public Long getDeliveryId() {
        return deliveryId;
    }

    /**
     * 发货主键ID
     */
    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    /**
     * 发货明细主键ID
     */
    public Long getDeliveryDetailId() {
        return deliveryDetailId;
    }

    /**
     * 发货明细主键ID
     */
    public void setDeliveryDetailId(Long deliveryDetailId) {
        this.deliveryDetailId = deliveryDetailId;
    }
    /**
     * 订单主键ID
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键ID
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 订单明细主键ID
     */
    public Long getOrderDetailId() {
        return orderDetailId;
    }

    /**
     * 订单明细主键ID
     */
    public void setOrderDetailId(Long orderDetailId) {
        this.orderDetailId = orderDetailId;
    }
    
}
