package com.ejianc.business.supbusiness.proequipment.delivery.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.supbusiness.proequipment.delivery.vo.EquipmentDeliveryDetailVO;

/**
 * 设备租赁-验收表
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁-验收表")
public class EquipmentDeliveryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("来源发货单主键")
    private Long sourceId;
    @ApiModelProperty("订单主键")
    private Long orderId;
    @ApiModelProperty("订单单据编号")
    private String orderBillCode;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目code")
    private String projectCode;
    @ApiModelProperty("供应商主键")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("送货人名称")
    private Long deliverId; // 送货人名称
    @ApiModelProperty("送货人名称")
    private String deliverName;
    @ApiModelProperty("送货人联系电话")
    private String deliverPhone;
    @ApiModelProperty("预计到货日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date arriveDate;
    @ApiModelProperty("车牌号")
    private String licensePlate;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("是否关闭，0-否，1-是")
    private Integer closeFlag;
    @ApiModelProperty("验收状态，0-待接收,1-部分接收,2-全部接收")
    private Integer checkStatus;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("验收来源，0-自制验收,1-发货验收")
    private String sourceType;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("使用部位")
    private String construction;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("来源系统主键")
    private String systemId;

    @ApiModelProperty("订单联系人")
    private Long linkId;
    @ApiModelProperty("订单联系人名称")
    private String linkName;
    @ApiModelProperty("订单要求到货日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date orderExpiryDate;

    private String billStateName;

    @ApiModelProperty("设备租赁-验收明细")
    private List<EquipmentDeliveryDetailVO> equipmentDeliveryDetailList = new ArrayList<>();

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getDeliverId() {
        return deliverId;
    }
    @ReferDeserialTransfer
    public void setDeliverId(Long deliverId) {
        this.deliverId = deliverId;
    }

    /**
     * 来源发货单主键
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源发货单主键
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 订单主键
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 订单单据编号
     */
    public String getOrderBillCode() {
        return orderBillCode;
    }

    /**
     * 订单单据编号
     */
    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同code
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同code
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目code
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目code
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 供应商主键
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商主键
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 送货人名称
     */
    public String getDeliverName() {
        return deliverName;
    }

    /**
     * 送货人名称
     */
    public void setDeliverName(String deliverName) {
        this.deliverName = deliverName;
    }
    /**
     * 送货人联系电话
     */
    public String getDeliverPhone() {
        return deliverPhone;
    }

    /**
     * 送货人联系电话
     */
    public void setDeliverPhone(String deliverPhone) {
        this.deliverPhone = deliverPhone;
    }
    /**
     * 预计到货日期
     */
    public Date getArriveDate() {
        return arriveDate;
    }

    /**
     * 预计到货日期
     */
    public void setArriveDate(Date arriveDate) {
        this.arriveDate = arriveDate;
    }
    /**
     * 车牌号
     */
    public String getLicensePlate() {
        return licensePlate;
    }

    /**
     * 车牌号
     */
    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 是否关闭，0-否，1-是
     */
    public Integer getCloseFlag() {
        return closeFlag;
    }

    /**
     * 是否关闭，0-否，1-是
     */
    public void setCloseFlag(Integer closeFlag) {
        this.closeFlag = closeFlag;
    }
    /**
     * 验收状态，0-待接收,1-部分接收,2-全部接收
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * 验收状态，0-待接收,1-部分接收,2-全部接收
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 验收来源，0-自制验收,1-发货验收
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * 验收来源，0-自制验收,1-发货验收
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 使用部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 使用部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 父级组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 来源系统主键
     */
    public String getSystemId() {
        return systemId;
    }

    /**
     * 来源系统主键
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Long getLinkId() {
        return linkId;
    }

    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }

    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    public void setOrderExpiryDate(Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
      * 设备租赁-验收明细
      */
      public List<EquipmentDeliveryDetailVO> getEquipmentDeliveryDetailList() {
         return equipmentDeliveryDetailList;
      }
     /**
      * 设备租赁-验收明细
      */
     public void setEquipmentDeliveryDetailList(List<EquipmentDeliveryDetailVO> equipmentDeliveryDetailList) {
         this.equipmentDeliveryDetailList = equipmentDeliveryDetailList;
     }
}
