package com.ejianc.business.supbusiness.proequipment.settlement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.supbusiness.proequipment.settlement.vo.TemporarySettlementDetailVO;
import com.ejianc.business.supbusiness.proequipment.settlement.vo.TemporarySettlementFeeVO;

/**
 * 设备租赁-临时租赁结算
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁-临时租赁结算")
public class TemporarySettlementVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("供应商")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("结算日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settlementDate;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章")
    private Integer signatureStatus;
    @ApiModelProperty("签字状态，0-未签字,1-已签字")
    private Integer signStatus;
    @ApiModelProperty("结算类型，0-过程,1-最终")
    private Integer settlementType;
    @ApiModelProperty("结算金额(无税)")
    private BigDecimal settlementMny;
    @ApiModelProperty("结算金额")
    private BigDecimal settlementTaxMny;
    @ApiModelProperty("结算税额")
    private BigDecimal settlementTax;
    @ApiModelProperty("租赁金额(无税)")
    private BigDecimal rentTotalMny;
    @ApiModelProperty("租赁金额")
    private BigDecimal rentTotalTaxMny;
    @ApiModelProperty("租赁税额")
    private BigDecimal rentTotalTax;
    @ApiModelProperty("其他金额(无税)")
    private BigDecimal otherMny;
    @ApiModelProperty("其他金额")
    private BigDecimal otherTaxMny;
    @ApiModelProperty("其他税额")
    private BigDecimal otherTax;
    @ApiModelProperty("合同金额")
    private BigDecimal contractTaxMny;
    @ApiModelProperty("合同金额（无税）")
    private BigDecimal contractMny;
    @ApiModelProperty("合同税额")
    private BigDecimal contractTax;
    @ApiModelProperty("合同收票金额")
    private BigDecimal contractInvoiceTaxMny;
    @ApiModelProperty("合同收票金额(不含税)")
    private BigDecimal contractInvoiceMny;
    @ApiModelProperty("合同已付金额")
    private BigDecimal contractPayMny;
    @ApiModelProperty("含本期结算金额")
    private BigDecimal currentSettlementTaxMny;
    @ApiModelProperty("含本期结算金额（无税）")
    private BigDecimal currentSettlementMny;
    @ApiModelProperty("合同支付比例")
    private BigDecimal contractPaymentRatio;
    @ApiModelProperty("")
    private String supOperatorUserCode;
    @ApiModelProperty("")
    private String supOperatorPhone;
    @ApiModelProperty("")
    private String supOperatorName;
    @ApiModelProperty("")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;
    @ApiModelProperty("单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方")
    private String billPushFlag;
    @ApiModelProperty("关联状态(1:是，0：否)")
    private String relationFlag;
    @ApiModelProperty("分摊状态(1:是，0：否)")
    private String proportionFlag;
    @ApiModelProperty("来源订单主键")
    private Long sourceId;
    @ApiModelProperty("来源系统主键")
    private String systemId;
    @ApiModelProperty("乙方签字状态:已签字-1,未签字-0")
    private Integer supplierSignStatus;
    
    @ApiModelProperty("设备租赁-临时租赁结算明细")
    private List<TemporarySettlementDetailVO> temporarySettlementDetailList = new ArrayList<>();
    @ApiModelProperty("设备租赁-临时租赁结算其他费用")
    private List<TemporarySettlementFeeVO> temporarySettlementFeeList = new ArrayList<>();

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 结算日期
     */
    public Date getSettlementDate() {
        return settlementDate;
    }

    /**
     * 结算日期
     */
    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    /**
     * 签字状态，0-未签字,1-已签字
     */
    public Integer getSignStatus() {
        return signStatus;
    }

    /**
     * 签字状态，0-未签字,1-已签字
     */
    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    /**
     * 结算类型，0-过程,1-最终
     */
    public Integer getSettlementType() {
        return settlementType;
    }

    /**
     * 结算类型，0-过程,1-最终
     */
    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }
    /**
     * 结算金额(无税)
     */
    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    /**
     * 结算金额(无税)
     */
    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    /**
     * 结算金额
     */
    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    /**
     * 结算金额
     */
    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }
    /**
     * 结算税额
     */
    public BigDecimal getSettlementTax() {
        return settlementTax;
    }

    /**
     * 结算税额
     */
    public void setSettlementTax(BigDecimal settlementTax) {
        this.settlementTax = settlementTax;
    }
    /**
     * 租赁金额(无税)
     */
    public BigDecimal getRentTotalMny() {
        return rentTotalMny;
    }

    /**
     * 租赁金额(无税)
     */
    public void setRentTotalMny(BigDecimal rentTotalMny) {
        this.rentTotalMny = rentTotalMny;
    }
    /**
     * 租赁金额
     */
    public BigDecimal getRentTotalTaxMny() {
        return rentTotalTaxMny;
    }

    /**
     * 租赁金额
     */
    public void setRentTotalTaxMny(BigDecimal rentTotalTaxMny) {
        this.rentTotalTaxMny = rentTotalTaxMny;
    }
    /**
     * 租赁税额
     */
    public BigDecimal getRentTotalTax() {
        return rentTotalTax;
    }

    /**
     * 租赁税额
     */
    public void setRentTotalTax(BigDecimal rentTotalTax) {
        this.rentTotalTax = rentTotalTax;
    }
    /**
     * 其他金额(无税)
     */
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    /**
     * 其他金额(无税)
     */
    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    /**
     * 其他金额
     */
    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    /**
     * 其他金额
     */
    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }
    /**
     * 其他税额
     */
    public BigDecimal getOtherTax() {
        return otherTax;
    }

    /**
     * 其他税额
     */
    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }
    /**
     * 合同金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同金额（无税）
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额（无税）
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同税额
     */
    public BigDecimal getContractTax() {
        return contractTax;
    }

    /**
     * 合同税额
     */
    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    /**
     * 合同收票金额
     */
    public BigDecimal getContractInvoiceTaxMny() {
        return contractInvoiceTaxMny;
    }

    /**
     * 合同收票金额
     */
    public void setContractInvoiceTaxMny(BigDecimal contractInvoiceTaxMny) {
        this.contractInvoiceTaxMny = contractInvoiceTaxMny;
    }
    /**
     * 合同收票金额(不含税)
     */
    public BigDecimal getContractInvoiceMny() {
        return contractInvoiceMny;
    }

    /**
     * 合同收票金额(不含税)
     */
    public void setContractInvoiceMny(BigDecimal contractInvoiceMny) {
        this.contractInvoiceMny = contractInvoiceMny;
    }
    /**
     * 合同已付金额
     */
    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    /**
     * 合同已付金额
     */
    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }
    /**
     * 含本期结算金额
     */
    public BigDecimal getCurrentSettlementTaxMny() {
        return currentSettlementTaxMny;
    }

    /**
     * 含本期结算金额
     */
    public void setCurrentSettlementTaxMny(BigDecimal currentSettlementTaxMny) {
        this.currentSettlementTaxMny = currentSettlementTaxMny;
    }
    /**
     * 含本期结算金额（无税）
     */
    public BigDecimal getCurrentSettlementMny() {
        return currentSettlementMny;
    }

    /**
     * 含本期结算金额（无税）
     */
    public void setCurrentSettlementMny(BigDecimal currentSettlementMny) {
        this.currentSettlementMny = currentSettlementMny;
    }
    /**
     * 合同支付比例
     */
    public BigDecimal getContractPaymentRatio() {
        return contractPaymentRatio;
    }

    /**
     * 合同支付比例
     */
    public void setContractPaymentRatio(BigDecimal contractPaymentRatio) {
        this.contractPaymentRatio = contractPaymentRatio;
    }
    /**
     * 
     */
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    /**
     * 
     */
    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    /**
     * 
     */
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    /**
     * 
     */
    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    /**
     * 
     */
    public String getSupOperatorName() {
        return supOperatorName;
    }

    /**
     * 
     */
    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    /**
     * 
     */
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    /**
     * 
     */
    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    public String getBillPushFlag() {
        return billPushFlag;
    }

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }
    /**
     * 关联状态(1:是，0：否)
     */
    public String getRelationFlag() {
        return relationFlag;
    }

    /**
     * 关联状态(1:是，0：否)
     */
    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }
    /**
     * 分摊状态(1:是，0：否)
     */
    public String getProportionFlag() {
        return proportionFlag;
    }

    /**
     * 分摊状态(1:是，0：否)
     */
    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }
    /**
     * 来源订单主键
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源订单主键
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源系统主键
     */
    public String getSystemId() {
        return systemId;
    }

    /**
     * 来源系统主键
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    /**
     * 乙方签字状态:已签字-1,未签字-0
     */
    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    /**
     * 乙方签字状态:已签字-1,未签字-0
     */
    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }
    
     /**
      * 设备租赁-临时租赁结算明细
      */
      public List<TemporarySettlementDetailVO> getTemporarySettlementDetailList() {
         return temporarySettlementDetailList;
      }
     /**
      * 设备租赁-临时租赁结算明细
      */
     public void setTemporarySettlementDetailList(List<TemporarySettlementDetailVO> temporarySettlementDetailList) {
         this.temporarySettlementDetailList = temporarySettlementDetailList;
     }
     /**
      * 设备租赁-临时租赁结算其他费用
      */
      public List<TemporarySettlementFeeVO> getTemporarySettlementFeeList() {
         return temporarySettlementFeeList;
      }
     /**
      * 设备租赁-临时租赁结算其他费用
      */
     public void setTemporarySettlementFeeList(List<TemporarySettlementFeeVO> temporarySettlementFeeList) {
         this.temporarySettlementFeeList = temporarySettlementFeeList;
     }
}
