package com.ejianc.business.supbusiness.proequipment.start.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 设备租赁-设备退场明细
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁-设备退场明细")
public class EquipmentAppearanceDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    @ApiModelProperty("设备出厂编码")
    private String equipmentExitCode;
    @ApiModelProperty("设备类别")
    private String equipmentType;
    @ApiModelProperty("设备类别ID")
    private Long equipmentTypeId;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("设备名称ID")
    private Long equipmentNameId;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位")
    private String billingUnit;
    @ApiModelProperty("计租方式")
    private String rentType;
    @ApiModelProperty("进场日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date approachDate;
    @ApiModelProperty("出场日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date appearanceDate;
    @ApiModelProperty("止租日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rentEndDate;
    @ApiModelProperty("备注")
    private String detailMemo;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("主表id")
    private Long pid;
    @ApiModelProperty("来源id/台账id")
    private Long sourceId;
    

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 设备出厂编码
     */
    public String getEquipmentExitCode() {
        return equipmentExitCode;
    }

    /**
     * 设备出厂编码
     */
    public void setEquipmentExitCode(String equipmentExitCode) {
        this.equipmentExitCode = equipmentExitCode;
    }
    /**
     * 设备类别
     */
    public String getEquipmentType() {
        return equipmentType;
    }

    /**
     * 设备类别
     */
    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }
    /**
     * 设备类别ID
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 设备类别ID
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 设备名称ID
     */
    public Long getEquipmentNameId() {
        return equipmentNameId;
    }

    /**
     * 设备名称ID
     */
    public void setEquipmentNameId(Long equipmentNameId) {
        this.equipmentNameId = equipmentNameId;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getBillingUnit() {
        return billingUnit;
    }

    /**
     * 计量单位
     */
    public void setBillingUnit(String billingUnit) {
        this.billingUnit = billingUnit;
    }
    /**
     * 计租方式
     */
    public String getRentType() {
        return rentType;
    }

    /**
     * 计租方式
     */
    public void setRentType(String rentType) {
        this.rentType = rentType;
    }
    /**
     * 进场日期
     */
    public Date getApproachDate() {
        return approachDate;
    }

    /**
     * 进场日期
     */
    public void setApproachDate(Date approachDate) {
        this.approachDate = approachDate;
    }
    /**
     * 出场日期
     */
    public Date getAppearanceDate() {
        return appearanceDate;
    }

    /**
     * 出场日期
     */
    public void setAppearanceDate(Date appearanceDate) {
        this.appearanceDate = appearanceDate;
    }
    /**
     * 止租日期
     */
    public Date getRentEndDate() {
        return rentEndDate;
    }

    /**
     * 止租日期
     */
    public void setRentEndDate(Date rentEndDate) {
        this.rentEndDate = rentEndDate;
    }
    /**
     * 备注
     */
    public String getDetailMemo() {
        return detailMemo;
    }

    /**
     * 备注
     */
    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 主表id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 主表id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }
    /**
     * 来源id/台账id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源id/台账id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    
}
