package com.ejianc.business.supbusiness.proequipment.start.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 设备租赁-设备启用明细
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁-设备启用明细")
public class EquipmentStartDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String code;
    @ApiModelProperty("费用项目名称")
    private String name;
    @ApiModelProperty("单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    @ApiModelProperty("设备出厂编号")
    private String equipmentAppearanceCode;
    @ApiModelProperty("设备类型")
    private String equipmentType;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("规格型号")
    private String specs;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("启用-停用-时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date typeDate;
    @ApiModelProperty("主表id")
    private Long pid;
    @ApiModelProperty("启用状态:1--启用,2--停用")
    private Integer state;
    @ApiModelProperty("")
    private Integer rentTypeId;
    @ApiModelProperty("计租方式名称")
    private String rentTypeName;
    @ApiModelProperty("启用/停用数量")
    private Integer num;
    @ApiModelProperty("来源id/台账id")
    private Long sourceId;
    

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 费用项目名称
     */
    public String getName() {
        return name;
    }

    /**
     * 费用项目名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 设备出厂编号
     */
    public String getEquipmentAppearanceCode() {
        return equipmentAppearanceCode;
    }

    /**
     * 设备出厂编号
     */
    public void setEquipmentAppearanceCode(String equipmentAppearanceCode) {
        this.equipmentAppearanceCode = equipmentAppearanceCode;
    }
    /**
     * 设备类型
     */
    public String getEquipmentType() {
        return equipmentType;
    }

    /**
     * 设备类型
     */
    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }
    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 规格型号
     */
    public String getSpecs() {
        return specs;
    }

    /**
     * 规格型号
     */
    public void setSpecs(String specs) {
        this.specs = specs;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 启用-停用-时间
     */
    public Date getTypeDate() {
        return typeDate;
    }

    /**
     * 启用-停用-时间
     */
    public void setTypeDate(Date typeDate) {
        this.typeDate = typeDate;
    }
    /**
     * 主表id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 主表id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }
    /**
     * 启用状态:1--启用,2--停用
     */
    public Integer getState() {
        return state;
    }

    /**
     * 启用状态:1--启用,2--停用
     */
    public void setState(Integer state) {
        this.state = state;
    }
    /**
     * 
     */
    public Integer getRentTypeId() {
        return rentTypeId;
    }

    /**
     * 
     */
    public void setRentTypeId(Integer rentTypeId) {
        this.rentTypeId = rentTypeId;
    }
    /**
     * 计租方式名称
     */
    public String getRentTypeName() {
        return rentTypeName;
    }

    /**
     * 计租方式名称
     */
    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }
    /**
     * 启用/停用数量
     */
    public Integer getNum() {
        return num;
    }

    /**
     * 启用/停用数量
     */
    public void setNum(Integer num) {
        this.num = num;
    }
    /**
     * 来源id/台账id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源id/台账id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    
}
