package com.ejianc.business.supbusiness.proequipment.start.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.supbusiness.proequipment.start.vo.EquipmentStartDetailVO;

/**
 * 设备租赁-设备启用
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁-设备启用")
public class EquipmentStartVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String code;
    @ApiModelProperty("费用项目名称")
    private String name;
    @ApiModelProperty("单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("项目id")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("所属单位id")
    private Long companyId;
    @ApiModelProperty("所属单位名称")
    private String companyName;
    @ApiModelProperty("供应商id")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("启动-停用-时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date typeDate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("签字状态:1--未签字,2---已签字")
    private Integer signState;
    @ApiModelProperty("编制日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date organizationDate;
    @ApiModelProperty("状态:1---启用---2--停用")
    private Integer type;
    @ApiModelProperty("验收单id")
    private Long acceptanceId;
    @ApiModelProperty("项目部ID")
    private Long projectDepartmentId;
    @ApiModelProperty("项目部名称")
    private String projectDepartmentName;
    @ApiModelProperty("提交日期")
    private Date commitDate;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("来源订单主键")
    private Long sourceId;
    @ApiModelProperty("来源系统主键")
    private String systemId;
    @ApiModelProperty("乙方签字状态:已签字-1,未签字-0")
    private Integer supplierSignStatus;
    @ApiModelProperty("供方经办人名称")
    private String supOperatorName;
    @ApiModelProperty("供方经办人手机号")
    private String supOperatorPhone;
    @ApiModelProperty("供方经办人账号")
    private String supOperatorUserCode;
    @ApiModelProperty("供方经办人签字时间")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;
    
    @ApiModelProperty("设备租赁-设备启用明细")
    private List<EquipmentStartDetailVO> equipmentStartDetailList = new ArrayList<>();

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 费用项目名称
     */
    public String getName() {
        return name;
    }

    /**
     * 费用项目名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属单位id
     */
    public Long getCompanyId() {
        return companyId;
    }

    /**
     * 所属单位id
     */
    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    /**
     * 所属单位名称
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * 所属单位名称
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    /**
     * 供应商id
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 启动-停用-时间
     */
    public Date getTypeDate() {
        return typeDate;
    }

    /**
     * 启动-停用-时间
     */
    public void setTypeDate(Date typeDate) {
        this.typeDate = typeDate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 签字状态:1--未签字,2---已签字
     */
    public Integer getSignState() {
        return signState;
    }

    /**
     * 签字状态:1--未签字,2---已签字
     */
    public void setSignState(Integer signState) {
        this.signState = signState;
    }
    /**
     * 编制日期
     */
    public Date getOrganizationDate() {
        return organizationDate;
    }

    /**
     * 编制日期
     */
    public void setOrganizationDate(Date organizationDate) {
        this.organizationDate = organizationDate;
    }
    /**
     * 状态:1---启用---2--停用
     */
    public Integer getType() {
        return type;
    }

    /**
     * 状态:1---启用---2--停用
     */
    public void setType(Integer type) {
        this.type = type;
    }
    /**
     * 验收单id
     */
    public Long getAcceptanceId() {
        return acceptanceId;
    }

    /**
     * 验收单id
     */
    public void setAcceptanceId(Long acceptanceId) {
        this.acceptanceId = acceptanceId;
    }
    /**
     * 项目部ID
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部ID
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 项目部名称
     */
    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    /**
     * 项目部名称
     */
    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }
    /**
     * 提交日期
     */
    public Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 来源订单主键
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源订单主键
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源系统主键
     */
    public String getSystemId() {
        return systemId;
    }

    /**
     * 来源系统主键
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    /**
     * 乙方签字状态:已签字-1,未签字-0
     */
    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    /**
     * 乙方签字状态:已签字-1,未签字-0
     */
    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }
    /**
     * 供方经办人名称
     */
    public String getSupOperatorName() {
        return supOperatorName;
    }

    /**
     * 供方经办人名称
     */
    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    /**
     * 供方经办人手机号
     */
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    /**
     * 供方经办人手机号
     */
    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    /**
     * 供方经办人账号
     */
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    /**
     * 供方经办人账号
     */
    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    /**
     * 供方经办人签字时间
     */
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    /**
     * 供方经办人签字时间
     */
    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    
     /**
      * 设备租赁-设备启用明细
      */
      public List<EquipmentStartDetailVO> getEquipmentStartDetailList() {
         return equipmentStartDetailList;
      }
     /**
      * 设备租赁-设备启用明细
      */
     public void setEquipmentStartDetailList(List<EquipmentStartDetailVO> equipmentStartDetailList) {
         this.equipmentStartDetailList = equipmentStartDetailList;
     }
}
