package com.ejianc.business.supbusiness.proequipment.use.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.supbusiness.proequipment.use.vo.TemporaryUseRecordDetailVO;
import com.ejianc.business.supbusiness.proequipment.use.vo.EquipmentUseRecordDetailVO;

/**
 * 设备租赁-临时租赁使用记录
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁-临时租赁使用记录")
public class TemporaryUseRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目id")
    private Long projectId;
    @ApiModelProperty("所属单位")
    private String projectOrg;
    @ApiModelProperty("所属单位id")
    private Long projectOrgId;
    @ApiModelProperty("供应商")
    private String supplierName;
    @ApiModelProperty("供应商id")
    private Long supplierId;
    @ApiModelProperty("开始日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;
    @ApiModelProperty("结束日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;
    @ApiModelProperty("使用金额")
    private BigDecimal useMny;
    @ApiModelProperty("经办人")
    private String employee;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("项目部ID")
    private Long projectDepartmentId;
    @ApiModelProperty("项目部名称")
    private String projectDepartmentName;
    @ApiModelProperty("有无合同")
    private Integer noContract;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("来源订单主键")
    private Long sourceId;
    @ApiModelProperty("来源系统主键")
    private String systemId;
    @ApiModelProperty("乙方签字状态:已签字-1,未签字-0")
    private Integer supplierSignStatus;
    @ApiModelProperty("供方经办人名称")
    private String supOperatorName;
    @ApiModelProperty("供方经办人手机号")
    private String supOperatorPhone;
    @ApiModelProperty("供方经办人账号")
    private String supOperatorUserCode;
    @ApiModelProperty("供方经办人签字时间")
    private Date supOperateTime;
    @ApiModelProperty("是否签字")
    private Integer notSignature;
    private Long partyId; // 甲方
    private String partyName; // 甲方名称
    
    @ApiModelProperty("设备租赁-临时租赁使用记录明细")
    private List<TemporaryUseRecordDetailVO> temporaryUseRecordSubList   = new ArrayList<>();

    public Long getPartyId() {
        return partyId;
    }

    public void setPartyId(Long partyId) {
        this.partyId = partyId;
    }

    public String getPartyName() {
        return partyName;
    }

    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 所属单位
     */
    public String getProjectOrg() {
        return projectOrg;
    }

    /**
     * 所属单位
     */
    public void setProjectOrg(String projectOrg) {
        this.projectOrg = projectOrg;
    }
    /**
     * 所属单位id
     */
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    /**
     * 所属单位id
     */
    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    /**
     * 供应商
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供应商id
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 开始日期
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * 开始日期
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 结束日期
     */
    public Date getEndDate() {
        return endDate;
    }

    /**
     * 结束日期
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 使用金额
     */
    public BigDecimal getUseMny() {
        return useMny;
    }

    /**
     * 使用金额
     */
    public void setUseMny(BigDecimal useMny) {
        this.useMny = useMny;
    }
    /**
     * 经办人
     */
    public String getEmployee() {
        return employee;
    }

    /**
     * 经办人
     */
    public void setEmployee(String employee) {
        this.employee = employee;
    }
    /**
     * 经办人id
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 项目部ID
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部ID
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 项目部名称
     */
    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    /**
     * 项目部名称
     */
    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }
    /**
     * 有无合同
     */
    public Integer getNoContract() {
        return noContract;
    }

    /**
     * 有无合同
     */
    public void setNoContract(Integer noContract) {
        this.noContract = noContract;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 来源订单主键
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源订单主键
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源系统主键
     */
    public String getSystemId() {
        return systemId;
    }

    /**
     * 来源系统主键
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    /**
     * 乙方签字状态:已签字-1,未签字-0
     */
    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    /**
     * 乙方签字状态:已签字-1,未签字-0
     */
    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }
    /**
     * 供方经办人名称
     */
    public String getSupOperatorName() {
        return supOperatorName;
    }

    /**
     * 供方经办人名称
     */
    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    /**
     * 供方经办人手机号
     */
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    /**
     * 供方经办人手机号
     */
    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    /**
     * 供方经办人账号
     */
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    /**
     * 供方经办人账号
     */
    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    /**
     * 供方经办人签字时间
     */
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    /**
     * 供方经办人签字时间
     */
    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    /**
     * 是否签字
     */
    public Integer getNotSignature() {
        return notSignature;
    }

    /**
     * 是否签字
     */
    public void setNotSignature(Integer notSignature) {
        this.notSignature = notSignature;
    }

    public List<TemporaryUseRecordDetailVO> getTemporaryUseRecordSubList() {
        return temporaryUseRecordSubList;
    }

    public void setTemporaryUseRecordSubList(List<TemporaryUseRecordDetailVO> temporaryUseRecordSubList) {
        this.temporaryUseRecordSubList = temporaryUseRecordSubList;
    }
}
