package com.ejianc.business.supbusiness.promaterial.concreteorder.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 消耗材送货单明细表
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材送货单明细表")
public class ConcreteDeliveryDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("发货主键ID")
    private Long deliveryId;
    @ApiModelProperty("订单主键ID")
    private Long orderId;
    @ApiModelProperty("订单明细主键ID")
    private Long orderDetailId;
    @ApiModelProperty("物资主键")
    private Long materialId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资类别")
    private Long materialTypeId;
    @ApiModelProperty("物资类别名称")
    private String materialTypeName;
    @ApiModelProperty("物料编码")
    private String materialCode;
    @ApiModelProperty("单位名称")
    private String unit;
    @ApiModelProperty("单位主键")
    private Long unitId;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("发货数量")
    private BigDecimal deliveryNum;
    @ApiModelProperty("验收数量")
    private BigDecimal checkNum;
    @ApiModelProperty("接收数量")
    private BigDecimal receiveNumsSum;
    @ApiModelProperty("未发货数量")
    private BigDecimal notShippedNumSum;
    @ApiModelProperty("已发货数量")
    private BigDecimal shippedNumSum;
    @ApiModelProperty("使用部位")
    private String construction;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单价")
    private BigDecimal price;
    @ApiModelProperty("含税单价")
    private BigDecimal taxPrice;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("外加剂名称")
    private String admixtureName;
    @ApiModelProperty("外加剂id")
    private String admixtureId;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("浇筑时间")
    private Date castDateTime;
    private Integer detailAutomaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）

    public Integer getDetailAutomaticWeigh() {
        return detailAutomaticWeigh;
    }

    public void setDetailAutomaticWeigh(Integer detailAutomaticWeigh) {
        this.detailAutomaticWeigh = detailAutomaticWeigh;
    }

    /**
     * 发货主键ID
     */
    public Long getDeliveryId() {
        return deliveryId;
    }

    /**
     * 发货主键ID
     */
    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    /**
     * 订单主键ID
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键ID
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 订单明细主键ID
     */
    public Long getOrderDetailId() {
        return orderDetailId;
    }

    /**
     * 订单明细主键ID
     */
    public void setOrderDetailId(Long orderDetailId) {
        this.orderDetailId = orderDetailId;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 单位名称
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位名称
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位主键
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位主键
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 发货数量
     */
    public BigDecimal getDeliveryNum() {
        return deliveryNum;
    }

    /**
     * 发货数量
     */
    public void setDeliveryNum(BigDecimal deliveryNum) {
        this.deliveryNum = deliveryNum;
    }
    /**
     * 验收数量
     */
    public BigDecimal getCheckNum() {
        return checkNum;
    }

    /**
     * 验收数量
     */
    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }
    /**
     * 接收数量
     */
    public BigDecimal getReceiveNumsSum() {
        return receiveNumsSum;
    }

    /**
     * 接收数量
     */
    public void setReceiveNumsSum(BigDecimal receiveNumsSum) {
        this.receiveNumsSum = receiveNumsSum;
    }
    /**
     * 未发货数量
     */
    public BigDecimal getNotShippedNumSum() {
        return notShippedNumSum;
    }

    /**
     * 未发货数量
     */
    public void setNotShippedNumSum(BigDecimal notShippedNumSum) {
        this.notShippedNumSum = notShippedNumSum;
    }
    /**
     * 已发货数量
     */
    public BigDecimal getShippedNumSum() {
        return shippedNumSum;
    }

    /**
     * 已发货数量
     */
    public void setShippedNumSum(BigDecimal shippedNumSum) {
        this.shippedNumSum = shippedNumSum;
    }
    /**
     * 使用部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 使用部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getAdmixtureName() {
        return admixtureName;
    }

    public void setAdmixtureName(String admixtureName) {
        this.admixtureName = admixtureName;
    }

    public String getAdmixtureId() {
        return admixtureId;
    }

    public void setAdmixtureId(String admixtureId) {
        this.admixtureId = admixtureId;
    }

    public Date getCastDateTime() {
        return castDateTime;
    }

    public void setCastDateTime(Date castDateTime) {
        this.castDateTime = castDateTime;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
}
