package com.ejianc.business.supbusiness.promaterial.order.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 消耗材验收单
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材验收单")
public class MaterialCheckTbVO{
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("订单主键")
    private Long orderId;
    @ApiModelProperty("发货主键")
    private Long deliveryId;
    @ApiModelProperty("验收状态（0-未验收，1--已验收）")
    private Integer checkState;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目code")
    private String projectCode;
    @ApiModelProperty("供应商主键")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("验收人名称")
    private String checkerName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("验收日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate;
    @ApiModelProperty("车牌号")
    private String licensePlate;
    @ApiModelProperty("是否补录，0-否，1-是")
    private Integer recordFlag;
    @ApiModelProperty("补录原因")
    private String recordReson;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("验收类型，proMaterial-1,大宗材 proMaterial-2,周转材 proMaterial-3,零星材料 proMaterial-4, 甲供材")
    private String checkType;
    @ApiModelProperty("验收类型，proMaterial-1,大宗材 proMaterial-2,周转材 proMaterial-3,零星材料 proMaterial-4, 甲供材")
    private String checkTypeName;
    @ApiModelProperty("入库方式，0-收料入库，1-直入直出")
    private String storeType;
    @ApiModelProperty("验收来源，0-自制验收,1-发货验收")
    private Integer sourceType;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("仓库主键")
    private Long storeId;
    @ApiModelProperty("仓库名称")
    private String storeName;
    @ApiModelProperty("入库日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date instoreDate;
    @ApiModelProperty("分包合同主键")
    private Long subContractId;
    @ApiModelProperty("分包合同名称")
    private String subContractName;
    @ApiModelProperty("分包合同code")
    private String subContractCode;
    @ApiModelProperty("分包合同供应商主键")
    private Long subSupplierId;
    @ApiModelProperty("分包合同供应商名称")
    private String subSupplierName;
    @ApiModelProperty("分包负责人名称")
    private String subEmployeeName;
    @ApiModelProperty("联系电话")
    private String subEmployeePhone;
    @ApiModelProperty("使用部位")
    private String construction;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("小票数量")
    private BigDecimal ticketNum;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("来源订单主键")
    private Long sourceId;
    @ApiModelProperty("来源系统主键")
    private String systemId;

    /**
     * 乙方签字状态:已签字-1,未签字-0
     */
    private Integer supplierSignStatus;
    /**
     * 供方经办人名称
     */
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;

    @ApiModelProperty("消耗材验收单明细表")
    private List<MaterialCheckDetailTbVO> checkDetailList = new ArrayList<>();

    /**
     * 订单主键
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 发货主键
     */
    public Long getDeliveryId() {
        return deliveryId;
    }

    /**
     * 发货主键
     */
    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    /**
     * 验收状态（0-未验收，1--已验收）
     */
    public Integer getCheckState() {
        return checkState;
    }

    /**
     * 验收状态（0-未验收，1--已验收）
     */
    public void setCheckState(Integer checkState) {
        this.checkState = checkState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同code
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同code
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目code
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目code
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 供应商主键
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商主键
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 验收人名称
     */
    public String getCheckerName() {
        return checkerName;
    }

    /**
     * 验收人名称
     */
    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 验收日期
     */
    public Date getCheckDate() {
        return checkDate;
    }

    /**
     * 验收日期
     */
    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    /**
     * 车牌号
     */
    public String getLicensePlate() {
        return licensePlate;
    }

    /**
     * 车牌号
     */
    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    /**
     * 是否补录，0-否，1-是
     */
    public Integer getRecordFlag() {
        return recordFlag;
    }

    /**
     * 是否补录，0-否，1-是
     */
    public void setRecordFlag(Integer recordFlag) {
        this.recordFlag = recordFlag;
    }
    /**
     * 补录原因
     */
    public String getRecordReson() {
        return recordReson;
    }

    /**
     * 补录原因
     */
    public void setRecordReson(String recordReson) {
        this.recordReson = recordReson;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 验收类型，proMaterial-1,大宗材
proMaterial-2,周转材
proMaterial-3,零星材料
proMaterial-4, 甲供材
     */
    public String getCheckType() {
        return checkType;
    }

    /**
     * 验收类型，proMaterial-1,大宗材
proMaterial-2,周转材
proMaterial-3,零星材料
proMaterial-4, 甲供材
     */
    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }
    /**
     * 验收类型，proMaterial-1,大宗材
proMaterial-2,周转材
proMaterial-3,零星材料
proMaterial-4, 甲供材
     */
    public String getCheckTypeName() {
        return checkTypeName;
    }

    /**
     * 验收类型，proMaterial-1,大宗材
proMaterial-2,周转材
proMaterial-3,零星材料
proMaterial-4, 甲供材
     */
    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }
    /**
     * 入库方式，0-收料入库，1-直入直出
     */
    public String getStoreType() {
        return storeType;
    }

    /**
     * 入库方式，0-收料入库，1-直入直出
     */
    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }
    /**
     * 验收来源，0-自制验收,1-发货验收
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 验收来源，0-自制验收,1-发货验收
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 仓库主键
     */
    public Long getStoreId() {
        return storeId;
    }

    /**
     * 仓库主键
     */
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    /**
     * 仓库名称
     */
    public String getStoreName() {
        return storeName;
    }

    /**
     * 仓库名称
     */
    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    /**
     * 入库日期
     */
    public Date getInstoreDate() {
        return instoreDate;
    }

    /**
     * 入库日期
     */
    public void setInstoreDate(Date instoreDate) {
        this.instoreDate = instoreDate;
    }
    /**
     * 分包合同主键
     */
    public Long getSubContractId() {
        return subContractId;
    }

    /**
     * 分包合同主键
     */
    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }
    /**
     * 分包合同名称
     */
    public String getSubContractName() {
        return subContractName;
    }

    /**
     * 分包合同名称
     */
    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }
    /**
     * 分包合同code
     */
    public String getSubContractCode() {
        return subContractCode;
    }

    /**
     * 分包合同code
     */
    public void setSubContractCode(String subContractCode) {
        this.subContractCode = subContractCode;
    }
    /**
     * 分包合同供应商主键
     */
    public Long getSubSupplierId() {
        return subSupplierId;
    }

    /**
     * 分包合同供应商主键
     */
    public void setSubSupplierId(Long subSupplierId) {
        this.subSupplierId = subSupplierId;
    }
    /**
     * 分包合同供应商名称
     */
    public String getSubSupplierName() {
        return subSupplierName;
    }

    /**
     * 分包合同供应商名称
     */
    public void setSubSupplierName(String subSupplierName) {
        this.subSupplierName = subSupplierName;
    }
    /**
     * 分包负责人名称
     */
    public String getSubEmployeeName() {
        return subEmployeeName;
    }

    /**
     * 分包负责人名称
     */
    public void setSubEmployeeName(String subEmployeeName) {
        this.subEmployeeName = subEmployeeName;
    }
    /**
     * 联系电话
     */
    public String getSubEmployeePhone() {
        return subEmployeePhone;
    }

    /**
     * 联系电话
     */
    public void setSubEmployeePhone(String subEmployeePhone) {
        this.subEmployeePhone = subEmployeePhone;
    }
    /**
     * 使用部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 使用部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 小票数量
     */
    public BigDecimal getTicketNum() {
        return ticketNum;
    }

    /**
     * 小票数量
     */
    public void setTicketNum(BigDecimal ticketNum) {
        this.ticketNum = ticketNum;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 来源订单主键
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源订单主键
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源系统主键
     */
    public String getSystemId() {
        return systemId;
    }

    /**
     * 来源系统主键
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public List<MaterialCheckDetailTbVO> getCheckDetailList() {
        return checkDetailList;
    }

    public void setCheckDetailList(List<MaterialCheckDetailTbVO> checkDetailList) {
        this.checkDetailList = checkDetailList;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
}
