package com.ejianc.business.supbusiness.promaterial.reconciliation.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.supbusiness.promaterial.reconciliation.vo.ReconciliationDetailVO;
import com.ejianc.business.supbusiness.promaterial.reconciliation.vo.ReconciliationCollectVO;

/**
 * 消耗材（混凝土）对账单表
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材（混凝土）对账单表")
public class ReconciliationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("供应商")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("对账日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date reconciliationDate;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("合同采购编码")
    private String contractPropertyCode;
    @ApiModelProperty("合同采购（属性）名称")
    private String contractPropertyName;
    @ApiModelProperty("对账金额")
    private BigDecimal reconciliationMny;
    @ApiModelProperty("对账金额(含税)")
    private BigDecimal reconciliationTaxMny;
    @ApiModelProperty("合同金额")
    private BigDecimal contractTaxMny;
    @ApiModelProperty("合同金额（无税）")
    private BigDecimal contractMny;
    @ApiModelProperty("签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章")
    private String signatureStatus;
    @ApiModelProperty("签字状态，0-未签字,1-已签字")
    private Integer signStatus;
    @ApiModelProperty("对账单类型（0-物资采购对账单，1-混凝土对账单）")
    private Integer reconciliationType;

    @ApiModelProperty("来源对账单主键")
    private Long sourceId;
    @ApiModelProperty("来源系统主键")
    private String systemId;

    /**
     * 供方经办人名称
     */
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;

    @ApiModelProperty("消耗材（混凝土）对账单明细表")
    private List<ReconciliationDetailVO> reconciliationDetailList = new ArrayList<>();
    @ApiModelProperty("消耗材（混凝土）对账单明细汇总表")
    private List<ReconciliationCollectVO> reconciliationCollectList = new ArrayList<>();

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 对账日期
     */
    public Date getReconciliationDate() {
        return reconciliationDate;
    }

    /**
     * 对账日期
     */
    public void setReconciliationDate(Date reconciliationDate) {
        this.reconciliationDate = reconciliationDate;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 合同采购编码
     */
    public String getContractPropertyCode() {
        return contractPropertyCode;
    }

    /**
     * 合同采购编码
     */
    public void setContractPropertyCode(String contractPropertyCode) {
        this.contractPropertyCode = contractPropertyCode;
    }
    /**
     * 合同采购（属性）名称
     */
    public String getContractPropertyName() {
        return contractPropertyName;
    }

    /**
     * 合同采购（属性）名称
     */
    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }
    /**
     * 对账金额
     */
    public BigDecimal getReconciliationMny() {
        return reconciliationMny;
    }

    /**
     * 对账金额
     */
    public void setReconciliationMny(BigDecimal reconciliationMny) {
        this.reconciliationMny = reconciliationMny;
    }
    /**
     * 对账金额(含税)
     */
    public BigDecimal getReconciliationTaxMny() {
        return reconciliationTaxMny;
    }

    /**
     * 对账金额(含税)
     */
    public void setReconciliationTaxMny(BigDecimal reconciliationTaxMny) {
        this.reconciliationTaxMny = reconciliationTaxMny;
    }
    /**
     * 合同金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同金额（无税）
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额（无税）
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public String getSignatureStatus() {
        return signatureStatus;
    }

    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public void setSignatureStatus(String signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    /**
     * 签字状态，0-未签字,1-已签字
     */
    public Integer getSignStatus() {
        return signStatus;
    }

    /**
     * 签字状态，0-未签字,1-已签字
     */
    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    /**
     * 对账单类型（0-物资采购对账单，1-混凝土对账单）
     */
    public Integer getReconciliationType() {
        return reconciliationType;
    }

    /**
     * 对账单类型（0-物资采购对账单，1-混凝土对账单）
     */
    public void setReconciliationType(Integer reconciliationType) {
        this.reconciliationType = reconciliationType;
    }
    
     /**
      * 消耗材（混凝土）对账单明细表
      */
      public List<ReconciliationDetailVO> getReconciliationDetailList() {
         return reconciliationDetailList;
      }
     /**
      * 消耗材（混凝土）对账单明细表
      */
     public void setReconciliationDetailList(List<ReconciliationDetailVO> reconciliationDetailList) {
         this.reconciliationDetailList = reconciliationDetailList;
     }
     /**
      * 消耗材（混凝土）对账单明细汇总表
      */
      public List<ReconciliationCollectVO> getReconciliationCollectList() {
         return reconciliationCollectList;
      }
     /**
      * 消耗材（混凝土）对账单明细汇总表
      */
     public void setReconciliationCollectList(List<ReconciliationCollectVO> reconciliationCollectList) {
         this.reconciliationCollectList = reconciliationCollectList;
     }
}
