package com.ejianc.business.supbusiness.prosub.process.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 零工登记主实体
 * 
 * @author generator
 * 
 */
public class RegistrationVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 项目Id
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目编码
     */
    private String projectCode;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合同id
     */
    private Long contractId;

    /**
     * 合同编码
     */
    private String contractCode;

    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    private Integer contractType;

    /**
     * 合同类别：0-主合同 1-补充协议
     */
    private Integer supplementFlag;

    /**
     * 项目部id
     */
    private Long orgId;

    /**
     * 项目部名称
     */
    private String orgName;

    /**
     * 项目部编码
     */
    private String orgCode;

    /**
     * 项目部所属组织id
     */
    private Long parentOrgId;

    /**
     * 项目部所属组织名称
     */
    private String parentOrgName;

    /**
     * 项目部所属组织编码
     */
    private String parentOrgCode;

    private Long firstPartyId;// 甲方Id

    private String firstPartyName;// 甲方名称

    /**
     * 供应商id(乙方)
     */
    private Long supplierId;

    /**
     * 供应商名称（乙方）
     */
    private String supplierName;

    /**
     * 申请人 即经办人
     */
    private Long employeeId;

    /**
     * 申请人信息 即经办人
     */
    private String employeeName;

    /**
     * 来源：0-自制、1-申请单—单据编号
     */
    private Integer billType;

    /**
     * 用工类型id
     */
    private Long useWorkTypeId;
    /**
     * 用工类型名称
     */
    private String useWorkTypeName;

    /**
     * 用工内容 手动输入 1-50个字，必填项
     */
    private String useWorkDetail;

    /**
     * 零工总金额：自动计算子表的含税总金额不支持修改（含税）
     */
    private java.math.BigDecimal totalTaxMny;

    /**
     * 零工总金额：自动计算子表的无税总金额不支持修改(无税)
     */
    private java.math.BigDecimal totalMny;

    /**
     * 签字状态 0:未签字显示：乙方未签字，1:签字显示：乙方已签字
     */
    private Integer supplierSignStatus;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    private Integer billState;

    /**
     * 经办人部门ID
     */
    private Long departmentId;
    /**
     * 提交日期
     */
    private Date commitDate;

    /**
     * 提交人名称
     */
    private String commitUserName;

    /**
     * 提交人账号
     */
    private String commitUserCode;

    /**
     * 生效日期
     */
    private Date effectiveDate;

    /**
     * 登记时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date regionDate;

    /**
     * 文件id
     */
    private List<String> fileIds = new ArrayList<>();

    /**
     * 零工登记申请Id
     */
    private Long applicationId;

    /**
     *  经办人部门
     */
    private String departmentName;

    /**
     * 零工登记 子表 清单明细
     */
    private List<RegistrationDetailVO> detailList = new ArrayList<>();

    /**
     * 零工登记子表 转扣表实体
     */
    private List<RegistrationDeductVO> deductList = new ArrayList<>();
    private List<RegistrationTeamVO> teamList = new ArrayList<>(); // 零工登记子表 转扣表实体

    /**
     *   班组id
     */
    private Long teamId;
    /**
     * 班组名称（带入）
     */
    private String teamName;
    /**
     * 班组编码
     */
    private String teamCode;

    /**
     * 制单人Id
     */
    private Long createUserId;

    /***  协同需要字段 START  ***/

    /**
     * 供方经办人名称
     */
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    private Long supOperateFileId;

    /**
     * 来源业务单据Id
     */
    private String sourceId;

    /**
     * 来源业务系统id
     */
    private String sourceSystemId;

    public Long getUseWorkTypeId() {
        return useWorkTypeId;
    }

    public void setUseWorkTypeId(Long useWorkTypeId) {
        this.useWorkTypeId = useWorkTypeId;
    }

    public String getUseWorkTypeName() {
        return useWorkTypeName;
    }

    public void setUseWorkTypeName(String useWorkTypeName) {
        this.useWorkTypeName = useWorkTypeName;
    }

    /***  协同需要字段 END  ***/

    public Date getCommitDate() {
        return commitDate;
    }

    public List<RegistrationTeamVO> getTeamList() {
        return teamList;
    }

    public void setTeamList(List<RegistrationTeamVO> teamList) {
        this.teamList = teamList;
    }

    public Long getTeamId() {
        return teamId;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public String getTeamCode() {
        return teamCode;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }

    public Long getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }


    public Date getRegionDate() {
        return regionDate;
    }

    public void setRegionDate(Date regionDate) {
        this.regionDate = regionDate;
    }

    public List<String> getFileIds() {
        return fileIds;
    }

    public void setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }



    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    /**
     * 项目Id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称（带入）
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称（带入）
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    public Integer getContractType() {
        return contractType;
    }

    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    /**
     * 合同类型：0-主合同 1-补充协议
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 合同类型：0-主合同 1-补充协议
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 项目部id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部所属组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部所属组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部所属组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部所属组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部所属组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部所属组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    /**
     * 供应商id(乙方)
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id(乙方)
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称（乙方）
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称（乙方）
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 申请人 即经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 申请人 即经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 申请人信息 即经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 申请人信息 即经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 来源：0-自制、1-申请单—单据编号
     */
    public Integer getBillType() {
        return billType;
    }

    /**
     * 来源：0-自制、1-申请单—单据编号
     */
    public void setBillType(Integer billType) {
        this.billType = billType;
    }
    /**
     * 用工内容 手动输入 1-50个字，必填项
     */
    public String getUseWorkDetail() {
        return useWorkDetail;
    }

    /**
     * 用工内容 手动输入 1-50个字，必填项
     */
    public void setUseWorkDetail(String useWorkDetail) {
        this.useWorkDetail = useWorkDetail;
    }
    /**
     * 零工总金额：自动计算子表的含税总金额不支持修改（含税）
     */
    public java.math.BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    /**
     * 零工总金额：自动计算子表的含税总金额不支持修改（含税）
     */
    public void setTotalTaxMny(java.math.BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }
    /**
     * 零工总金额：自动计算子表的无税总金额不支持修改(无税)
     */
    public java.math.BigDecimal getTotalMny() {
        return totalMny;
    }

    /**
     * 零工总金额：自动计算子表的无税总金额不支持修改(无税)
     */
    public void setTotalMny(java.math.BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    /**
     * 签字状态 0:未签字显示：乙方未签字，1:签字显示：乙方已签字
     */
    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    /**
     * 签字状态 0:未签字显示：乙方未签字，1:签字显示：乙方已签字
     */
    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     /**
      * 零工登记 子表 清单明细
      */
     public List<RegistrationDetailVO> getDetailList() {
        return detailList;
     }

     /**
      * 零工登记 子表 清单明细
      */
     public void setDetailList(List<RegistrationDetailVO> detailList) {
        this.detailList = detailList;
     }
     /**
      * 零工登记子表 转扣表实体
      */
     public List<RegistrationDeductVO> getDeductList() {
        return deductList;
     }

     /**
      * 零工登记子表 转扣表实体
      */
     public void setDeductList(List<RegistrationDeductVO> deductList) {
        this.deductList = deductList;
     }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }
}
