package com.ejianc.business.supbusiness.prosub.settle.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 结算子表-其他费用
 *
 * @author generator
 */
public class SettleOtherVO extends BaseVO {

    private static final long serialVersionUID = -4754802324390648888L;

    private Integer useFlag; // 是否引用过,否-0，是-1
    private Long settleId; // 结算id
    private Long contractId; // 合同id
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    private Integer settleType; // 结算类型：0-过程，1-完工，2-节点
    private Long projectId; // 项目Id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    private Long sourceId; // 其他费用id
    private String costName; // 费用名称
    private BigDecimal costTaxPrice; // 单价
    private BigDecimal costPrice; // 单价（无税）
    private BigDecimal costTaxRate; // 税率
    private BigDecimal costNum; // 合同量
    private BigDecimal num; // 本期结算量
    private BigDecimal taxMny; // 本期结算金额，本期结算金额=本期结算量*单价
    private BigDecimal mny; // 本期结算金额(无税)
    private BigDecimal tax; // 本期结算税额
    private String memo; // 备注
    private String sourceType; // 来源:合同、新增


    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getCostName() {
        return costName;
    }

    public void setCostName(String costName) {
        this.costName = costName;
    }

    public BigDecimal getCostTaxPrice() {
        return costTaxPrice;
    }

    public void setCostTaxPrice(BigDecimal costTaxPrice) {
        this.costTaxPrice = costTaxPrice;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public BigDecimal getCostTaxRate() {
        return costTaxRate;
    }

    public void setCostTaxRate(BigDecimal costTaxRate) {
        this.costTaxRate = costTaxRate;
    }

    public BigDecimal getCostNum() {
        return costNum;
    }

    public void setCostNum(BigDecimal costNum) {
        this.costNum = costNum;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
}
