package com.ejianc.business.supbusiness.proequipment.delivery.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 消耗材送货单明细表
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材送货单明细表")
public class EquipmentDeliveryDetailTbVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("来源发货主表id")
    private Long sourceId;
    @ApiModelProperty("来源发货子表id")
    private Long sourceDetailId;
    @ApiModelProperty("发货主键ID")
    private Long deliveryId;
    @ApiModelProperty("订单主键ID")
    private Long orderId;
    @ApiModelProperty("订单明细主键ID")
    private Long orderDetailId;
    @ApiModelProperty("物资主键")
    private Long materialId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资类别")
    private Long materialTypeId;
    @ApiModelProperty("物资类别名称")
    private String materialTypeName;
    @ApiModelProperty("物料编码")
    private String materialCode;
    @ApiModelProperty("单位名称")
    private String unit;
    @ApiModelProperty("单位主键")
    private Long unitId;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("发货数量")
    private BigDecimal deliveryNum;
    @ApiModelProperty("验收数量")
    private BigDecimal checkNum;
    @ApiModelProperty("使用部位")
    private String construction;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("验收单价(无税)")
    private BigDecimal price;
    @ApiModelProperty("验收单价(含税)")
    private BigDecimal taxPrice;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("合同主键ID")
    private Long contractId;
    @ApiModelProperty("合同明细主键ID")
    private Long contractDetailId;
    @ApiModelProperty("设备出厂编号")
    private String factoryCode;
    @ApiModelProperty("生产厂家")
    private String productionManufactor;
    @ApiModelProperty("租赁方式:1--日租,2--月租,3--工程量")
    private Integer rentType;
    @ApiModelProperty("租赁方式:1--日租,2--月租,3--工程量")
    private String rentTypeName;
    @ApiModelProperty("未发货数量")
    private BigDecimal notShippedNumSum;

    @ApiModelProperty("接收数量")
    private BigDecimal receiveNumsSum;
    @ApiModelProperty("已发货数量")
    private BigDecimal shippedNumSum;

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getOrderDetailId() {
        return orderDetailId;
    }

    public void setOrderDetailId(Long orderDetailId) {
        this.orderDetailId = orderDetailId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public BigDecimal getDeliveryNum() {
        return deliveryNum;
    }

    public void setDeliveryNum(BigDecimal deliveryNum) {
        this.deliveryNum = deliveryNum;
    }

    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }

    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public String getFactoryCode() {
        return factoryCode;
    }

    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode;
    }

    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }

    public Integer getRentType() {
        return rentType;
    }

    public void setRentType(Integer rentType) {
        this.rentType = rentType;
    }

    public String getRentTypeName() {
        return rentTypeName;
    }

    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }

    public BigDecimal getNotShippedNumSum() {
        return notShippedNumSum;
    }

    public void setNotShippedNumSum(BigDecimal notShippedNumSum) {
        this.notShippedNumSum = notShippedNumSum;
    }

    public BigDecimal getReceiveNumsSum() {
        return receiveNumsSum;
    }

    public void setReceiveNumsSum(BigDecimal receiveNumsSum) {
        this.receiveNumsSum = receiveNumsSum;
    }

    public BigDecimal getShippedNumSum() {
        return shippedNumSum;
    }

    public void setShippedNumSum(BigDecimal shippedNumSum) {
        this.shippedNumSum = shippedNumSum;
    }
}
