package com.ejianc.business.supbusiness.proequipment.settlement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 设备租赁-设备租赁结算工程量租明细
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁-设备租赁结算工程量租明细")
public class RentSettlementQuantitiesVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("结算主键ID")
    private Long settlementId;
    @ApiModelProperty("来源主键ID")
    private Long sourceId;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("来源类型名称(记录—100231)")
    private String sourceName;
    @ApiModelProperty("来源类型")
    private Integer sourceType;
    @ApiModelProperty("来源编码")
    private String sourceCode;
    @ApiModelProperty("出厂编码")
    private String quantitiesFactoryCode;
    @ApiModelProperty("设备类别")
    private Long equipmentTypeId;
    @ApiModelProperty("设备类别名称")
    private String equipmentTypeName;
    @ApiModelProperty("设备主键")
    private Long equipmentId;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("设备编码")
    private String equipmentCode;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("单位id")
    private Long unitId;
    @ApiModelProperty("计费单位")
    private String billingUnitName;
    @ApiModelProperty("计费单位id")
    private Long billingUnitId;
    @ApiModelProperty("开始日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date quantitiesStartDate;
    @ApiModelProperty("结束日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date quantitiesEndDate;
    @ApiModelProperty("工程租赁单价(无税)")
    private BigDecimal quantitiesPrice;
    @ApiModelProperty("工程租赁单价")
    private BigDecimal quantitiesTaxPrice;
    @ApiModelProperty("租赁数量")
    private BigDecimal rentNum;
    @ApiModelProperty("工程数量")
    private BigDecimal quantitiesNum;
    @ApiModelProperty("工程租赁金额(无税)")
    private BigDecimal quantitiesMny;
    @ApiModelProperty("工程租赁金额)")
    private BigDecimal quantitiesTaxMny;
    @ApiModelProperty("工程租赁税率")
    private BigDecimal quantitiesTaxRate;
    @ApiModelProperty("工程租赁税额")
    private BigDecimal quantitiesTax;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("生产厂家")
    private String productionManufactor;
    @ApiModelProperty("核算对象主键")
    private Long wbsId;
    @ApiModelProperty("核算对象编码")
    private String wbsCode;
    @ApiModelProperty("核算对象名称")
    private String wbsName;
    @ApiModelProperty("成本科目主键")
    private Long subjectId;
    @ApiModelProperty("成本科目编码")
    private String subjectCode;
    @ApiModelProperty("成本科目名称")
    private String subjectName;
    

    /**
     * 结算主键ID
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * 结算主键ID
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    /**
     * 来源主键ID
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键ID
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源明细主键ID
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源明细主键ID
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 来源类型名称(记录—100231)
     */
    public String getSourceName() {
        return sourceName;
    }

    /**
     * 来源类型名称(记录—100231)
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
    /**
     * 来源类型
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源编码
     */
    public String getSourceCode() {
        return sourceCode;
    }

    /**
     * 来源编码
     */
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    /**
     * 出厂编码
     */
    public String getQuantitiesFactoryCode() {
        return quantitiesFactoryCode;
    }

    /**
     * 出厂编码
     */
    public void setQuantitiesFactoryCode(String quantitiesFactoryCode) {
        this.quantitiesFactoryCode = quantitiesFactoryCode;
    }
    /**
     * 设备类别
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 设备类别
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    /**
     * 设备类别名称
     */
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    /**
     * 设备类别名称
     */
    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    /**
     * 设备主键
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备主键
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 设备编码
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编码
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计费单位
     */
    public String getBillingUnitName() {
        return billingUnitName;
    }

    /**
     * 计费单位
     */
    public void setBillingUnitName(String billingUnitName) {
        this.billingUnitName = billingUnitName;
    }
    /**
     * 计费单位id
     */
    public Long getBillingUnitId() {
        return billingUnitId;
    }

    /**
     * 计费单位id
     */
    public void setBillingUnitId(Long billingUnitId) {
        this.billingUnitId = billingUnitId;
    }
    /**
     * 开始日期
     */
    public Date getQuantitiesStartDate() {
        return quantitiesStartDate;
    }

    /**
     * 开始日期
     */
    public void setQuantitiesStartDate(Date quantitiesStartDate) {
        this.quantitiesStartDate = quantitiesStartDate;
    }
    /**
     * 结束日期
     */
    public Date getQuantitiesEndDate() {
        return quantitiesEndDate;
    }

    /**
     * 结束日期
     */
    public void setQuantitiesEndDate(Date quantitiesEndDate) {
        this.quantitiesEndDate = quantitiesEndDate;
    }
    /**
     * 工程租赁单价(无税)
     */
    public BigDecimal getQuantitiesPrice() {
        return quantitiesPrice;
    }

    /**
     * 工程租赁单价(无税)
     */
    public void setQuantitiesPrice(BigDecimal quantitiesPrice) {
        this.quantitiesPrice = quantitiesPrice;
    }
    /**
     * 工程租赁单价
     */
    public BigDecimal getQuantitiesTaxPrice() {
        return quantitiesTaxPrice;
    }

    /**
     * 工程租赁单价
     */
    public void setQuantitiesTaxPrice(BigDecimal quantitiesTaxPrice) {
        this.quantitiesTaxPrice = quantitiesTaxPrice;
    }
    /**
     * 租赁数量
     */
    public BigDecimal getRentNum() {
        return rentNum;
    }

    /**
     * 租赁数量
     */
    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }
    /**
     * 工程数量
     */
    public BigDecimal getQuantitiesNum() {
        return quantitiesNum;
    }

    /**
     * 工程数量
     */
    public void setQuantitiesNum(BigDecimal quantitiesNum) {
        this.quantitiesNum = quantitiesNum;
    }
    /**
     * 工程租赁金额(无税)
     */
    public BigDecimal getQuantitiesMny() {
        return quantitiesMny;
    }

    /**
     * 工程租赁金额(无税)
     */
    public void setQuantitiesMny(BigDecimal quantitiesMny) {
        this.quantitiesMny = quantitiesMny;
    }
    /**
     * 工程租赁金额)
     */
    public BigDecimal getQuantitiesTaxMny() {
        return quantitiesTaxMny;
    }

    /**
     * 工程租赁金额)
     */
    public void setQuantitiesTaxMny(BigDecimal quantitiesTaxMny) {
        this.quantitiesTaxMny = quantitiesTaxMny;
    }
    /**
     * 工程租赁税率
     */
    public BigDecimal getQuantitiesTaxRate() {
        return quantitiesTaxRate;
    }

    /**
     * 工程租赁税率
     */
    public void setQuantitiesTaxRate(BigDecimal quantitiesTaxRate) {
        this.quantitiesTaxRate = quantitiesTaxRate;
    }
    /**
     * 工程租赁税额
     */
    public BigDecimal getQuantitiesTax() {
        return quantitiesTax;
    }

    /**
     * 工程租赁税额
     */
    public void setQuantitiesTax(BigDecimal quantitiesTax) {
        this.quantitiesTax = quantitiesTax;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 生产厂家
     */
    public String getProductionManufactor() {
        return productionManufactor;
    }

    /**
     * 生产厂家
     */
    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    /**
     * 核算对象主键
     */
    public Long getWbsId() {
        return wbsId;
    }

    /**
     * 核算对象主键
     */
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    /**
     * 核算对象编码
     */
    public String getWbsCode() {
        return wbsCode;
    }

    /**
     * 核算对象编码
     */
    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }
    /**
     * 核算对象名称
     */
    public String getWbsName() {
        return wbsName;
    }

    /**
     * 核算对象名称
     */
    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    /**
     * 成本科目主键
     */
    public Long getSubjectId() {
        return subjectId;
    }

    /**
     * 成本科目主键
     */
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    /**
     * 成本科目编码
     */
    public String getSubjectCode() {
        return subjectCode;
    }

    /**
     * 成本科目编码
     */
    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    /**
     * 成本科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 成本科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    
}
