package com.ejianc.business.supplier.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 供应商准入
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supplier_access")
public class AccessEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 供方准入编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="bill_type")
    private Integer billType; // 1-分包，2-物资
    @TableField(value="name")
    private String name; // 供方准入名称
    @TableField(value="enterprise_nature")
    private Long enterpriseNature; // 企业性质
    @TableField(value="legal")
    private String legal; // 法定代表人
    @TableField(value="register_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date registerTime; // 注册日期
    @TableField(value="tax_payer_identifier")
    private String taxPayerIdentifier; // 纳税人识别号
    @TableField(value="tax_payer_type")
    private Long taxPayerType; // 纳税人类型
    @TableField(value="registered_capital")
    private java.math.BigDecimal registeredCapital; // 注册资金
    @TableField(value="legal_phone")
    private String legalPhone; // 法人电话
    @TableField(value="issuing_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date issuingTime; // 发证时间
    @TableField(value="category_id")
    private Long categoryId; // 供方分类id
    @TableField(value="category_name")
    private String categoryName; // 供方分类名称
    @TableField(value="social_credit_code")
    private String socialCreditCode; // 统一社会信用代码
    @TableField(value="address")
    private String address; // 详细地址
    @TableField(value="business_scope")
    private String businessScope; // 经营范围
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="bl_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date blTime; // 营业执照有效期
    @TableField(value="spl_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date splTime; // 安全生产许可证有效期
    @TableField(value="qc_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date qcTime; // 资质证书有效期
    @TableField(value="sc_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date scTime; // 安全证有效期
    @TableField(value="apply_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyTime; // 申请时间
    
    @TableField(exist=false)
    @SubEntity(serviceName="linkerService", pidName = "accessId")
    private List<LinkerEntity> linkerList = new ArrayList<>(); // 供应商联系人
    @TableField(exist=false)
    @SubEntity(serviceName="historicalPerformanceService", pidName = "accessId")
    private List<HistoricalPerformanceEntity> historicalPerformanceList = new ArrayList<>(); // 企业历史业绩
    @TableField(exist=false)
    @SubEntity(serviceName="bankAccountService", pidName = "accessId")
    private List<BankAccountEntity> bankAccountList = new ArrayList<>(); // 供应商银行账户
    

    /**
     * 供方准入编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 供方准入编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 1-分包，2-物资
     */
    public Integer getBillType() {
        return billType;
    }

    /**
     * 1-分包，2-物资
     */
    public void setBillType(Integer billType) {
        this.billType = billType;
    }
    /**
     * 供方准入名称
     */
    public String getName() {
        return name;
    }

    /**
     * 供方准入名称
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * 企业性质
     */
    public Long getEnterpriseNature() {
        return enterpriseNature;
    }

    /**
     * 企业性质
     */
    public void setEnterpriseNature(Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }

    /**
     * 法定代表人
     */
    public String getLegal() {
        return legal;
    }

    /**
     * 法定代表人
     */
    public void setLegal(String legal) {
        this.legal = legal;
    }
    /**
     * 注册日期
     */
    public java.util.Date getRegisterTime() {
        return registerTime;
    }

    /**
     * 注册日期
     */
    public void setRegisterTime(java.util.Date registerTime) {
        this.registerTime = registerTime;
    }
    /**
     * 纳税人识别号
     */
    public String getTaxPayerIdentifier() {
        return taxPayerIdentifier;
    }

    /**
     * 纳税人识别号
     */
    public void setTaxPayerIdentifier(String taxPayerIdentifier) {
        this.taxPayerIdentifier = taxPayerIdentifier;
    }
    
    /**
     * 纳税人类型
     */
    public Long getTaxPayerType() {
        return taxPayerType;
    }

    /**
     * 纳税人类型
     */
    public void setTaxPayerType(Long taxPayerType) {
        this.taxPayerType = taxPayerType;
    }

    /**
     * 注册资金
     */
    public java.math.BigDecimal getRegisteredCapital() {
        return registeredCapital;
    }

    /**
     * 注册资金
     */
    public void setRegisteredCapital(java.math.BigDecimal registeredCapital) {
        this.registeredCapital = registeredCapital;
    }
    /**
     * 法人电话
     */
    public String getLegalPhone() {
        return legalPhone;
    }

    /**
     * 法人电话
     */
    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }
    
    /**
     * 发证时间
     */
    public Date getIssuingTime() {
        return issuingTime;
    }

    /**
     * 发证时间
     */
    public void setIssuingTime(Date issuingTime) {
        this.issuingTime = issuingTime;
    }

    /**
     * 供方分类id
     */
    public Long getCategoryId() {
        return categoryId;
    }

    /**
     * 供方分类id
     */
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    /**
     * 供方分类名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 供方分类名称
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    /**
     * 统一社会信用代码
     */
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    /**
     * 统一社会信用代码
     */
    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    /**
     * 详细地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 详细地址
     */
    public void setAddress(String address) {
        this.address = address;
    }
    /**
     * 经营范围
     */
    public String getBusinessScope() {
        return businessScope;
    }

    /**
     * 经营范围
     */
    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 所属组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 营业执照有效期
     */
    public Date getBlTime() {
        return blTime;
    }

    /**
     * 营业执照有效期
     */
    public void setBlTime(Date blTime) {
        this.blTime = blTime;
    }

    /**
     * 安全生产许可证有效期
     */
    public Date getSplTime() {
        return splTime;
    }

    /**
     * 安全生产许可证有效期
     */
    public void setSplTime(Date splTime) {
        this.splTime = splTime;
    }

    /**
     * 资质证书有效期
     */
    public Date getQcTime() {
        return qcTime;
    }

    /**
     * 资质证书有效期
     */
    public void setQcTime(Date qcTime) {
        this.qcTime = qcTime;
    }

    /**
     * 安全证有效期
     */
    public Date getScTime() {
        return scTime;
    }

    /**
     * 安全证有效期
     */
    public void setScTime(Date scTime) {
        this.scTime = scTime;
    }

    /**
     * 申请时间
     */
    public Date getApplyTime() {
        return applyTime;
    }

    /**
     * 申请时间
     */
    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    /**
     * 供应商联系人
     */
    public List<LinkerEntity> getLinkerList() {
        return linkerList;
    }

    /**
     * 供应商联系人
     */
    public void setLinkerList(List<LinkerEntity> linkerList) {
        this.linkerList = linkerList;
    }

    /**
     * 企业历史业绩
     */
    public List<HistoricalPerformanceEntity> getHistoricalPerformanceList() {
        return historicalPerformanceList;
    }

    /**
     * 企业历史业绩
     */
    public void setHistoricalPerformanceList(List<HistoricalPerformanceEntity> historicalPerformanceList) {
        this.historicalPerformanceList = historicalPerformanceList;
    }

    /**
     * 供应商银行账户
     */
    public List<BankAccountEntity> getBankAccountList() {
        return bankAccountList;
    }

    /**
     * 供应商银行账户
     */
    public void setBankAccountList(List<BankAccountEntity> bankAccountList) {
        this.bankAccountList = bankAccountList;
    }
    
}
