package com.ejianc.business.supplier.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 供应商本年过程评价记录
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supplier_year_evaluate_course")
public class SupplierYearCourseEvaluateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="evaluation_project_id")
    private Long evaluationProjectId; // 评价项目主键
    @TableField(value="evaluation_project_name")
    private String evaluationProjectName; // 评价项目名称
    @TableField(value="evaluation_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date evaluationTime; // 评价时间
    @TableField(value="evaluation_score")
    private java.math.BigDecimal evaluationScore; // 评价得分
    @TableField(value="evaluation_grade")
    private Integer evaluationGrade; // 评价等级(1-合格，0-不合格)
    @TableField(value="bill_type")
    private Integer billType; // 1-分包；2-物资
    @TableField(value="year_evaluate_id")
    private Long yearEvaluateId; // 年度评价主键
    @TableField(value="supplier_id")
    private Long supplierId; // 供方主键
    @TableField(value="supplier_name")
    private String supplierName; // 供方名称
    @TableField(value="evaluation_grade_name")
    private String evaluationGradeName; // 评价等级名称
    @TableField(value="quarter")
    private Integer quarter; // 1-第一季度 2-第二季度 3- 第三季度
    @TableField(value="quarter_name")
    private String quarterName; // 季度名称
    @TableField(value="course_evaluate_id")
    private Long courseEvaluateId;//季度评价主键
    
    

    /**
     * 评价项目主键
     */
    public Long getEvaluationProjectId() {
        return evaluationProjectId;
    }

    /**
     * 评价项目主键
     */
    public void setEvaluationProjectId(Long evaluationProjectId) {
        this.evaluationProjectId = evaluationProjectId;
    }
    /**
     * 评价项目名称
     */
    public String getEvaluationProjectName() {
        return evaluationProjectName;
    }

    /**
     * 评价项目名称
     */
    public void setEvaluationProjectName(String evaluationProjectName) {
        this.evaluationProjectName = evaluationProjectName;
    }
    /**
     * 评价时间
     */
    public java.util.Date getEvaluationTime() {
        return evaluationTime;
    }

    /**
     * 评价时间
     */
    public void setEvaluationTime(java.util.Date evaluationTime) {
        this.evaluationTime = evaluationTime;
    }
    /**
     * 评价得分
     */
    public java.math.BigDecimal getEvaluationScore() {
        return evaluationScore;
    }

    /**
     * 评价得分
     */
    public void setEvaluationScore(java.math.BigDecimal evaluationScore) {
        this.evaluationScore = evaluationScore;
    }
    /**
     * 评价等级(1-合格，0-不合格)
     */
    public Integer getEvaluationGrade() {
        return evaluationGrade;
    }

    /**
     * 评价等级(1-合格，0-不合格)
     */
    public void setEvaluationGrade(Integer evaluationGrade) {
        this.evaluationGrade = evaluationGrade;
    }
    /**
     * 1-分包；2-物资
     */
    public Integer getBillType() {
        return billType;
    }

    /**
     * 1-分包；2-物资
     */
    public void setBillType(Integer billType) {
        this.billType = billType;
    }
    /**
     * 年度评价主键
     */
    public Long getYearEvaluateId() {
        return yearEvaluateId;
    }

    /**
     * 年度评价主键
     */
    public void setYearEvaluateId(Long yearEvaluateId) {
        this.yearEvaluateId = yearEvaluateId;
    }
    /**
     * 供方主键
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供方主键
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 评价等级名称
     */
    public String getEvaluationGradeName() {
        return evaluationGradeName;
    }

    /**
     * 评价等级名称
     */
    public void setEvaluationGradeName(String evaluationGradeName) {
        this.evaluationGradeName = evaluationGradeName;
    }
    /**
     * 1-第一季度 2-第二季度 3- 第三季度
     */
    public Integer getQuarter() {
        return quarter;
    }

    /**
     * 1-第一季度 2-第二季度 3- 第三季度
     */
    public void setQuarter(Integer quarter) {
        this.quarter = quarter;
    }
    /**
     * 季度名称
     */
    public String getQuarterName() {
        return quarterName;
    }

    /**
     * 季度名称
     */
    public void setQuarterName(String quarterName) {
        this.quarterName = quarterName;
    }

    public Long getCourseEvaluateId() {
        return courseEvaluateId;
    }

    public void setCourseEvaluateId(Long courseEvaluateId) {
        this.courseEvaluateId = courseEvaluateId;
    }
}
