package com.ejianc.business.supplier.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.supplier.mapper.SupplierReviewProjectMapper;
import com.ejianc.business.supplier.bean.SupplierReviewProjectEntity;
import com.ejianc.business.supplier.service.ISupplierReviewProjectService;

import java.util.List;

/**
 * 此单据用来生成实体类
 * 
 * @author generator
 * 
 */
@Service("supplierReviewProjectService")
public class SupplierReviewProjectServiceImpl extends BaseServiceImpl<SupplierReviewProjectMapper, SupplierReviewProjectEntity> implements ISupplierReviewProjectService{

    @Override
    public List<SupplierReviewProjectEntity> getSupplierReviewProjectList(Integer billType, Integer yearType) {
        LambdaQueryWrapper<SupplierReviewProjectEntity> queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SupplierReviewProjectEntity::getBillType,billType);
        queryWrapper.eq(SupplierReviewProjectEntity::getYearType,yearType);
        queryWrapper.eq(SupplierReviewProjectEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.orderByAsc(SupplierReviewProjectEntity::getIsOrder);
        List<SupplierReviewProjectEntity> list = super.list(queryWrapper);
        return list;
    }

}
