package com.ejianc.business.suppliercn15.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.suppliercn15.bean.InvestigateModleContentEntity;
import com.ejianc.business.suppliercn15.bean.InvestigateModleEntity;
import com.ejianc.business.suppliercn15.mapper.InvestigateModleMapper;
import com.ejianc.business.suppliercn15.service.IInvestigateModleContentService;
import com.ejianc.business.suppliercn15.service.IInvestigateModleService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 供应商考察模板
 * 
 * @author generator
 * 
 */
@Service("investigateModleService")
public class InvestigateModleServiceImpl extends BaseServiceImpl<InvestigateModleMapper, InvestigateModleEntity> implements IInvestigateModleService {
    @Autowired
    private IInvestigateModleContentService investigateModleContentService;

    @Autowired
    private InvestigateModleMapper investigateModMapper;

    /**
     * 根据类型名称查询数据
     * @param supplyTypeName
     * @return
     */
    public List<InvestigateModleContentEntity> queryTypeName(String supplyTypeName) {
        QueryParam param = new QueryParam();
        param.getParams().put("supplyType",new Parameter(QueryParam.EQ,supplyTypeName));
        param.getParams().put("state",new Parameter(QueryParam.EQ,true));
        param.getOrderMap().put("create_time","desc");
        List<InvestigateModleEntity> list = queryList(param,false);
        if(ListUtil.isNotEmpty(list)){
            /** 多个只取第一个 */
            InvestigateModleEntity entity =list.get(0);
            param = new QueryParam();
            param.getParams().put("zid",new Parameter(QueryParam.EQ,entity.getId()));
            List<InvestigateModleContentEntity> modleContentList =investigateModleContentService.queryList(param,false);
            return modleContentList;
        }
        return null;
    }

    /**
     * 列表修改状态
     * @param id
     * @param state
     */
    @Transactional
    public void updateState(Long id, Boolean state) {
        InvestigateModleEntity entity =this.getById(id);

        QueryWrapper<InvestigateModleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("supply_type", entity.getSupplyType());
        queryWrapper.eq("state", true);
        queryWrapper.ne("id", id);
        if(state){
            List<InvestigateModleEntity> list =investigateModMapper.selectList(queryWrapper);
            for (InvestigateModleEntity investigateModleEntity:list){
                investigateModleEntity.setState(false);
                this.saveOrUpdate(investigateModleEntity);
            }
        }

        entity.setState(state);
        this.saveOrUpdate(entity);
    }

    @Transactional
    public void saveOrUpdates(InvestigateModleEntity entity) {
        this.saveOrUpdate(entity,false);
        checkName(entity);
        saveOrUpdateChild(entity);
        //如果开启状态需要修改已开启的模板
        if(entity.getState()){
            QueryParam params = new QueryParam();
            params.getParams().put("supplyType",new Parameter(QueryParam.EQ,entity.getSupplyType()));
            params.getParams().put("state",new Parameter(QueryParam.EQ,true));

            List<InvestigateModleEntity> list =this.queryList(params);
            if(ListUtil.isNotEmpty(list) && list.get(0).getId()!=null && !list.get(0).getId().equals(entity.getId())){
                InvestigateModleEntity  investigateModleEntity = list.get(0);
                investigateModleEntity.setState(false);
                this.saveOrUpdate(investigateModleEntity);
            }
        }
    }

    @Transactional
    public void checkName(InvestigateModleEntity entity){
        QueryParam param = new QueryParam();
        param.getParams().put("name",new Parameter(QueryParam.EQ,entity.getName()));
        List<InvestigateModleEntity> list =this.queryList(param);
        if(ListUtil.isNotEmpty(list) && list.get(0).getId()!=null && !list.get(0).getId().equals(entity.getId())){
            throw new BusinessException("模板名称已经存在！");
        }
    }

    @Transactional
    public void saveOrUpdateChild(InvestigateModleEntity entity){
        List<InvestigateModleContentEntity> listbs = entity.getInvestigateModleContentEntities();
        Map<Long,Long> idMap=new HashMap<>();
        for(InvestigateModleContentEntity cdEntity:listbs){
            idMap.put(cdEntity.getTid(),cdEntity.getId());
        }
        for(InvestigateModleContentEntity cdEntity:listbs){
            if(999L!=cdEntity.getParentId()){
                cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                cdEntity.setTid(cdEntity.getId());

            }else{
                cdEntity.setTid(cdEntity.getId());
            }
        }
        investigateModleContentService.saveOrUpdateBatch(listbs,listbs.size(),false);
    }
}
