package com.ejianc.business.suppliercn15.bean;

import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 供应商准入
 * 
 * @author generator
 * 
 */
 @TableName("ejc_can_in")
public class CanInEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_name")
    private String projectName; // 寻源单位名称
    @TableField(value="create_user_name")
    private String createUserName; // 经办人
    @TableField(value="store_level")
    private String storeLevel; // 入库级别：一级库：L1，二级库：L2
    @TableField(value="level_type")
    private String levelType; // 入库形式：二级库首次录入：L2First/一级库转入：L1Turn/临时库转入：tempTurn
    @TableField(value="group_in")
    private String groupIn; // 集团内外：集团内：in，集团外：out
    @TableField(value="name")
    private String name; // 供应商名称
    @TableField(value="code")
    private String code; // 供应商编码
    @TableField(value="social_redit_code")
    private String socialReditCode; // 统一社会信用代码
    @TableField(value="register_mny")
    private String registerMny; // 注册资本
    @TableField(value="actual_register_mny")
    private String actualRegisterMny; // 实缴资本
    @TableField(value="register_status")
    private String registerStatus; // 登记状态
    @TableField(value="legal_person")
    private String legalPerson; // 法人代表
    @TableField(value="register_date")
    private String registerDate; // 成立日期
    @TableField(value="enterprise_type")
    private String enterpriseType; // 企业性质
    @TableField(value="area")
    private String area; // 注册地址
    @TableField(value="enterprise_base")
    private String enterpriseBase; // 企业属性: 流通型:L/非流通型:NL
    @TableField(value="national_name")
    private String nationalName; // 国家名称
    @TableField(value="grade_name")
    private String gradeName; // 等级名称
    @TableField(value="id_type")
    private String idType; // 证件类型:身份证:ID/护照P/港澳台通行证HMT
    @TableField(value="id_num")
    private String idNum; // 证件号码
    @TableField(value="tax_type")
    private String taxType; // 纳税人资格:一般纳税人normal/小规模纳税人small
    @TableField(value="inspect_code")
    private String inspectCode; // 考察单编码
    @TableField(value="inspect_result")
    private String inspectResult; // 考察结论：工程,70,合格;
    @TableField(value="project_supplier")
    private String projectSupplier; // 是否工程供应商
    @TableField(value="material_supplier")
    private String materialSupplier; // 是否货物供应商
    @TableField(value="service_supplier")
    private String serviceSupplier; // 是否服务供应商
    @TableField(value="project_content_id")
    private String projectContentId; // 工程供货内容
    @TableField(value="material_content_id")
    private String materialContentId; // 货物供货内容
    @TableField(value="service_content_id")
    private String serviceContentId; // 服务供货内容
    @TableField(value="run_scope")
    private String runScope; // 经营范围
    @TableField(value="org_memo")
    private String orgMemo; // 公司简介
    @TableField(value="temp_supplier")
    private String tempSupplier; // 是否临时供应商，是，否
    @TableField(value="need_inspect")
    private Integer needInspect; // 是否需要考察:true需要，false不需要
    @TableField(value="project_id")
    private Long projectId; // 寻源单位
    @TableField(value="national_id")
    private Long nationalId; // 国家id
    @TableField(value="grade_id")
    private Long gradeId; // 供应商等级id
    @TableField(value="inspect_id")
    private Long inspectId; // 考察单
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="canInAuthService")
    private List<CanInAuthEntity> canInAuthList = new ArrayList<>(); // 准入---授权委托人信息
    @TableField(exist=false)
    @SubEntity(serviceName="canInBankService")
    private List<CanInBankEntity> canInBankList = new ArrayList<>(); // 准入---银行信息
    @TableField(exist=false)
    @SubEntity(serviceName="canInCertService")
    private List<CanInCertEntity> canInCertList = new ArrayList<>(); // 准入---工程类供应商信息
    @TableField(exist=false)
    @SubEntity(serviceName="canInCoreTeamService")
    private List<CanInCoreTeamEntity> canInCoreTeamList = new ArrayList<>(); // 准入---核心团队
    

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getStoreLevel() {
        return storeLevel;
    }

    public void setStoreLevel(String storeLevel) {
        this.storeLevel = storeLevel;
    }
    public String getLevelType() {
        return levelType;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }
    public String getGroupIn() {
        return groupIn;
    }

    public void setGroupIn(String groupIn) {
        this.groupIn = groupIn;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getSocialReditCode() {
        return socialReditCode;
    }

    public void setSocialReditCode(String socialReditCode) {
        this.socialReditCode = socialReditCode;
    }
    public String getRegisterMny() {
        return registerMny;
    }

    public void setRegisterMny(String registerMny) {
        this.registerMny = registerMny;
    }
    public String getActualRegisterMny() {
        return actualRegisterMny;
    }

    public void setActualRegisterMny(String actualRegisterMny) {
        this.actualRegisterMny = actualRegisterMny;
    }
    public String getRegisterStatus() {
        return registerStatus;
    }

    public void setRegisterStatus(String registerStatus) {
        this.registerStatus = registerStatus;
    }
    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    public String getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(String registerDate) {
        this.registerDate = registerDate;
    }
    public String getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(String enterpriseType) {
        this.enterpriseType = enterpriseType;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getEnterpriseBase() {
        return enterpriseBase;
    }

    public void setEnterpriseBase(String enterpriseBase) {
        this.enterpriseBase = enterpriseBase;
    }
    public String getNationalName() {
        return nationalName;
    }

    public void setNationalName(String nationalName) {
        this.nationalName = nationalName;
    }
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }
    public String getIdNum() {
        return idNum;
    }

    public void setIdNum(String idNum) {
        this.idNum = idNum;
    }
    public String getTaxType() {
        return taxType;
    }

    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }
    public String getInspectCode() {
        return inspectCode;
    }

    public void setInspectCode(String inspectCode) {
        this.inspectCode = inspectCode;
    }
    public String getInspectResult() {
        return inspectResult;
    }

    public void setInspectResult(String inspectResult) {
        this.inspectResult = inspectResult;
    }
    public String getProjectSupplier() {
        return projectSupplier;
    }

    public void setProjectSupplier(String projectSupplier) {
        this.projectSupplier = projectSupplier;
    }
    public String getMaterialSupplier() {
        return materialSupplier;
    }

    public void setMaterialSupplier(String materialSupplier) {
        this.materialSupplier = materialSupplier;
    }
    public String getServiceSupplier() {
        return serviceSupplier;
    }

    public void setServiceSupplier(String serviceSupplier) {
        this.serviceSupplier = serviceSupplier;
    }
    public String getProjectContentId() {
        return projectContentId;
    }

    public void setProjectContentId(String projectContentId) {
        this.projectContentId = projectContentId;
    }
    public String getMaterialContentId() {
        return materialContentId;
    }

    public void setMaterialContentId(String materialContentId) {
        this.materialContentId = materialContentId;
    }
    public String getServiceContentId() {
        return serviceContentId;
    }

    public void setServiceContentId(String serviceContentId) {
        this.serviceContentId = serviceContentId;
    }
    public String getRunScope() {
        return runScope;
    }

    public void setRunScope(String runScope) {
        this.runScope = runScope;
    }
    public String getOrgMemo() {
        return orgMemo;
    }

    public void setOrgMemo(String orgMemo) {
        this.orgMemo = orgMemo;
    }
    public String getTempSupplier() {
        return tempSupplier;
    }

    public void setTempSupplier(String tempSupplier) {
        this.tempSupplier = tempSupplier;
    }
    public Integer getNeedInspect() {
        return needInspect;
    }

    public void setNeedInspect(Integer needInspect) {
        this.needInspect = needInspect;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getNationalId() {
        return nationalId;
    }

    public void setNationalId(Long nationalId) {
        this.nationalId = nationalId;
    }
    public Long getGradeId() {
        return gradeId;
    }

    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    public Long getInspectId() {
        return inspectId;
    }

    public void setInspectId(Long inspectId) {
        this.inspectId = inspectId;
    }
    

    public List<CanInAuthEntity> getCanInAuthList() {
        return canInAuthList;
    }

    public void setCanInAuthList(List<CanInAuthEntity> canInAuthList) {
        this.canInAuthList = canInAuthList;
    }

    public List<CanInBankEntity> getCanInBankList() {
        return canInBankList;
    }

    public void setCanInBankList(List<CanInBankEntity> canInBankList) {
        this.canInBankList = canInBankList;
    }

    public List<CanInCertEntity> getCanInCertList() {
        return canInCertList;
    }

    public void setCanInCertList(List<CanInCertEntity> canInCertList) {
        this.canInCertList = canInCertList;
    }

    public List<CanInCoreTeamEntity> getCanInCoreTeamList() {
        return canInCoreTeamList;
    }

    public void setCanInCoreTeamList(List<CanInCoreTeamEntity> canInCoreTeamList) {
        this.canInCoreTeamList = canInCoreTeamList;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
