package com.ejianc.foundation.supplier.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 供应商过程评价
 * 
 * @author generator
 * 
 */
public class SupplerIncidentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String name; // 考核内容
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 单据编码
    private Long contractId; // 合同id
    private String contractName; // 
    private String contractCode; // 合同编码
    private String performanceStatus; // 合同履约状态：1、未签订；2、履约中；3、已终止；4、已作废；      默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已终止】合同解除时，状态改为已作废
    private String contractType; // 合同类型
    private Long projectId; // 项目id
    private String projectName; // 
    private Long orgId; // 所属组织id
    private String orgName; // 
    private String orgCode; // 所属组织编码
    private Long parentOrgId; // 上级组织id
    private String parentOrgName; // 
    private String parentOrgCode; // 上级组织编码
    private BigDecimal contractAmount; // 合同金额
    private Long supplyId; // 供应商id
    private String supplyName; // 供应商名称
    private String source; // 评价来源
    private Long checkOrgId; // 考核单位id
    private String checkOrgName; // 考核单位名称
    private BigDecimal buckleBranch; // 本次扣分
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date; // 评价时间
    private Long processId; // 经办人id
    private String process; // 经办人
    private String memo; // 备注
    private Integer status; // 状态:0---未评价----1已评价
    private Long createUserId; // 评价人id
    private String createUserName; // 创建人名称
    private String phone; // 手机
    private Long headUserId; // 负责人id
    private String headUserName; // 分包负责人
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
    private String contractTypeName; // 合同分类名称
    private Integer evaluationObjState; // 评价对象（只有评价类型是劳务分包合同时该字段才会赋值）：1、劳务供应商；2、分包负责人；
    private String evaluationObjName; // 评价对象名称
    
    private List<SupplerIncidentContentVO> supplerIncidentContentList = new ArrayList<>(); // 供应商过程评价内容

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    public Long getSupplyId() {
        return supplyId;
    }

    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }
    public Long getCheckOrgId() {
        return checkOrgId;
    }

    public void setCheckOrgId(Long checkOrgId) {
        this.checkOrgId = checkOrgId;
    }
    public String getCheckOrgName() {
        return checkOrgName;
    }

    public void setCheckOrgName(String checkOrgName) {
        this.checkOrgName = checkOrgName;
    }
    public BigDecimal getBuckleBranch() {
        return buckleBranch;
    }

    public void setBuckleBranch(BigDecimal buckleBranch) {
        this.buckleBranch = buckleBranch;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public Long getProcessId() {
        return processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }
    public String getProcess() {
        return process;
    }

    public void setProcess(String process) {
        this.process = process;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public Long getHeadUserId() {
        return headUserId;
    }

    public void setHeadUserId(Long headUserId) {
        this.headUserId = headUserId;
    }
    public String getHeadUserName() {
        return headUserName;
    }

    public void setHeadUserName(String headUserName) {
        this.headUserName = headUserName;
    }
    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }
    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }
    public Integer getEvaluationObjState() {
        return evaluationObjState;
    }

    public void setEvaluationObjState(Integer evaluationObjState) {
        this.evaluationObjState = evaluationObjState;
    }
    public String getEvaluationObjName() {
        return evaluationObjName;
    }

    public void setEvaluationObjName(String evaluationObjName) {
        this.evaluationObjName = evaluationObjName;
    }
    
     public List<SupplerIncidentContentVO> getSupplerIncidentContentList() {
        return supplerIncidentContentList;
     }

     public void setSupplerIncidentContentList(List<SupplerIncidentContentVO> supplerIncidentContentList) {
        this.supplerIncidentContentList = supplerIncidentContentList;
     }
}
