package com.ejianc.foundation.supplier.util;

import io.micrometer.core.instrument.util.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @author songlx
 * @version 1.0
 * @description: 获取供应商查询分类
 * @date 2022/5/7
 */
public class SupplyQueryTypeUtil {

    //------start-------云南查询分类----------------------------------

    private static List<String> RULE_A_MATERIALEQUIPMENT = Arrays.asList(
            ContractTypeEnum.物资采购合同.getTypeCode(),
            ContractTypeEnum.周转材合同.getTypeCode(),
            ContractTypeEnum.混凝土合同.getTypeCode(),
            ContractTypeEnum.辅料中心周转材租赁合同.getTypeCode(),
            ContractTypeEnum.辅料中心周转材采购合同.getTypeCode(),
            ContractTypeEnum.设备采购.getTypeCode(),
            ContractTypeEnum.设备租赁.getTypeCode(),
            ContractTypeEnum.临时设备.getTypeCode(),
            ContractTypeEnum.安拆合同.getTypeCode()
    );

    private static List<String> RULE_A_SUB = Arrays.asList(
            ContractTypeEnum.专业分包合同.getTypeCode(),
            ContractTypeEnum.劳务分包合同.getTypeCode()
    );

    //------end-------云南查询分类----------------------------------


    //------start-------郑州查询分类----------------------------------


    private static List<String> RULE_B_MATERIAL = Arrays.asList(
            ContractTypeEnum.物资采购合同.getTypeCode(),
            ContractTypeEnum.周转材合同.getTypeCode(),
            ContractTypeEnum.混凝土合同.getTypeCode(),
            ContractTypeEnum.辅料中心周转材租赁合同.getTypeCode(),
            ContractTypeEnum.辅料中心周转材采购合同.getTypeCode()
    );

    private static List<String> RULE_B_EQUIPMENT = Arrays.asList(
            ContractTypeEnum.设备采购.getTypeCode(),
            ContractTypeEnum.设备租赁.getTypeCode(),
            ContractTypeEnum.临时设备.getTypeCode(),
            ContractTypeEnum.安拆合同.getTypeCode()
    );

    private static List<String> RULE_B_PRO_SUB = Arrays.asList(
            ContractTypeEnum.专业分包合同.getTypeCode()
    );

    private static List<String> RULE_B_LAB_SUB = Arrays.asList(
            ContractTypeEnum.劳务分包合同.getTypeCode()
    );

    //------end-------郑州查询分类----------------------------------


    //------start-------公用其他查询分类----------------------------------

    private static List<String> OTHER = Arrays.asList(
            ContractTypeEnum.其他支出.getTypeCode()
    );

    //------end-------公用查询分类----------------------------------



    /**
     * @param ruleName     规则名称
     * @param contractType 合同类型
     * @description: 获取供应商查询分类
     * @return: java.lang.String
     * @author songlx
     * @date: 2022/5/7
     */
    public static String get(String ruleName, String contractType) {
        // 云南供应商分类规则
        if ("RULE_A".equals(ruleName)) {
            if (RULE_A_MATERIALEQUIPMENT.contains(contractType)) {
                return "materialEquipment";
            } else if (RULE_A_SUB.contains(contractType)) {
                return "sub";
            } else if (OTHER.contains(contractType)) {
                return "other";
            }else{
                return "";
            }
        } else {
            if (RULE_B_MATERIAL.contains(contractType)) {
                return "material";
            } else if (RULE_B_EQUIPMENT.contains(contractType)) {
                return "equipment";
            } else if (RULE_B_PRO_SUB.contains(contractType)) {
                return "proSub";
            } else if (RULE_B_LAB_SUB.contains(contractType)) {
                return "laborSub";
            } else if (OTHER.contains(contractType)) {
                return "other";
            }else{
                return "";
            }
        }
    }


    // 中文名称
    public static String getEName(String typeCode) {
        if(StringUtils.isEmpty(typeCode)){
            return "";
        }
        if(RULE_B_MATERIAL.contains(typeCode)){
            return "material";
        }
        if(RULE_B_EQUIPMENT.contains(typeCode)){
            return "equipment";
        }
        if(RULE_B_PRO_SUB.contains(typeCode)){
            return "major";
        }
        if(RULE_B_LAB_SUB.contains(typeCode)){
            return "labor";
        }else{
            return "other";
        }
    }

    // 中文名称
    public static String getName(String typeCode) {
        if(StringUtils.isEmpty(typeCode)){
            return "";
        }
        if(RULE_B_MATERIAL.contains(typeCode)){
            return "物资";
        }
        if(RULE_B_EQUIPMENT.contains(typeCode)){
            return "设备";
        }
        if(RULE_B_PRO_SUB.contains(typeCode)){
            return "专业分包";
        }
        if(RULE_B_LAB_SUB.contains(typeCode)){
            return "劳务分包";
        }else{
            return "其他";
        }
    }


    public static void main(String[] args) {
        System.out.println(SupplyQueryTypeUtil.get("RULE_B", "contractMaterial"));
    }
}
