package com.ejianc.foundation.share.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;
/**
 * 物料审核
 * 
 * @author generator
 * 
 */
 @TableName("ejc_support_material_audit")
public class MaterialAuditEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="opt_flag")
    private String optFlag; // 操作类型
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="theme")
    private String theme; // 主题
    @TableField(value="material_names")
    private String materialNames; // 物料名称
    @TableField(value="employee_id")
    private Long employeeId; // 编制人
    @TableField(value="employee_name")
    private String employeeName; // 编制人
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 审核状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="materialAuditDetailService")
    private List<MaterialAuditDetailEntity> materialAuditDetailList = new ArrayList<>(); // 物料审核-明细
    

    public String getOptFlag() {
        return optFlag;
    }

    public void setOptFlag(String optFlag) {
        this.optFlag = optFlag;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }
    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<MaterialAuditDetailEntity> getMaterialAuditDetailList() {
        return materialAuditDetailList;
    }

    public void setMaterialAuditDetailList(List<MaterialAuditDetailEntity> materialAuditDetailList) {
        this.materialAuditDetailList = materialAuditDetailList;
    }
}
