package com.ejianc.foundation.share.controller.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.ProjectEntity;
import com.ejianc.foundation.share.service.IProjectService;
import com.ejianc.foundation.share.vo.ProjectPriceVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;

@RestController
@RequestMapping("/api/zjkj/projectApi/")
public class ZjkjProjectApi {

    @Autowired
    private IProjectService projectService;
    @Autowired
	private IOrgApi iOrgApi;

    /**
     * 根据项目Id查询项目信息
     *
     * @param id
     * @return
     */
    @GetMapping("queryDetailById")
    public CommonResponse<ProjectVO> queryDetailById(@RequestParam(value = "id") Long id) {
    	ProjectEntity entity = projectService.selectById(id);
    	ProjectVO vo = BeanMapper.map(entity, ProjectVO.class);
    	List<ProjectPriceVO> projectPriceList = new ArrayList<>();
    	ProjectPriceVO ProjectPriceVO = BeanMapper.map(entity, ProjectPriceVO.class);
    	projectPriceList.add(ProjectPriceVO);
    	vo.setProjectPriceList(projectPriceList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveProject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectVO> saveProject(@RequestBody ProjectVO projectVO) {
    	ProjectVO vo = projectService.saveData(projectVO);
    	return CommonResponse.success("修改项目成功！",vo);
    }
    
    /**
     * 根据项目Id查询项目信息
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailByparam", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectVO> queryDetailByparam(@RequestBody Map<String,Object> param) {
    	ProjectVO vo = null;
    	QueryWrapper<ProjectEntity> queryWrapper = new QueryWrapper<>();
    	if(param.get("projectName")!=null){
    		queryWrapper.eq("project_name", param.get("projectName"));
    	}
    	if(param.get("projectCode")!=null){
    		queryWrapper.eq("bill_code", param.get("projectCode"));
    	}
    	
		List<ProjectEntity> list = projectService.list(queryWrapper);
		if(list!=null&&list.size()>0){
			ProjectEntity entity = list.get(0);
	    	vo = BeanMapper.map(entity, ProjectVO.class);
	    	List<ProjectPriceVO> projectPriceList = new ArrayList<>();
	    	ProjectPriceVO ProjectPriceVO = BeanMapper.map(entity, ProjectPriceVO.class);
	    	projectPriceList.add(ProjectPriceVO);
	    	vo.setProjectPriceList(projectPriceList);
		}
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 查询项目数量
     * @param section
     * @return
     */
    @GetMapping("findProjectNum")
    CommonResponse<Integer> findProjectNum(@RequestParam(value = "section") String section) {
        Integer projectNum = projectService.queryProjectNum(section);
        return CommonResponse.success("查询成功！", projectNum);
    }

	/**
	 * 查询项目数量
	 * @return
	 */
	@GetMapping("findProjectAll")
	CommonResponse<List<ProjectVO>> findProjectAll() {
		List<Long> orgIds =iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

		QueryParam param = new QueryParam();
		param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
		param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));

		List<ProjectEntity> list = projectService.queryList(param);
		List<ProjectVO> voList =BeanMapper.mapList(list,ProjectVO.class);
		return CommonResponse.success("查询成功！", voList);
	}

	/**
	 * 根据ids查询项目详情
	 *
	 * @param ids
	 * @return
	 */
	@PostMapping(value = "queryProjectArray")
	public CommonResponse<JSONArray> queryProjectArray(@RequestBody List<Long> ids){
		List<ProjectVO> vos = new ArrayList<>();
		QueryWrapper<ProjectEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("dr", 0);
		queryWrapper.in("id", ids);
		List<ProjectEntity> entitys = projectService.list(queryWrapper);
//		if(entitys!=null){
//			vos = BeanMapper.mapList(entitys, ProjectRegisterVO.class);
//		}
		return CommonResponse.success("查询成功！", JSONArray.parseArray(JSONObject.toJSONString(entitys)));
	}

	/**
	 * 查询项目
	 * @return
	 */
	@PostMapping("queryProjects")
	@ResponseBody
	CommonResponse<List<ProjectVO>> queryProjects(@RequestBody QueryParam param) {
		Long orgId = InvocationInfoProxy.getOrgId();
		if(param.getParams().get("orgId")!=null){
			orgId = Long.valueOf(String.valueOf(param.getParams().get("orgId").getValue()));
			param.getParams().remove("orgId");
		}
		List<Long> orgIds =iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
		/** 移动端参照标识 */
		if(param.getParams().containsKey("mobileLeave")){
			//移动端没有当前组织，按照当前登录人权限取组织
			CommonResponse<List<OrgVO>> response = iOrgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
			if(response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())){
				orgIds = response.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
			}
			param.getParams().remove("mobileLeave");
		}
		param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
		param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));
		List<ProjectEntity> list = projectService.queryList(param);
		List<ProjectVO> voList =BeanMapper.mapList(list,ProjectVO.class);
		return CommonResponse.success("查询成功！", voList);
	}

	/**
	 * 查询项目
	 * @return
	 */
	@PostMapping("queryArray")
	@ResponseBody
	CommonResponse<JSONArray> queryArray(@RequestBody QueryParam param) {
		Long orgId = InvocationInfoProxy.getOrgId();
		if(param.getParams().get("orgId")!=null){
			orgId = Long.valueOf(String.valueOf(param.getParams().get("orgId").getValue()));
			param.getParams().remove("orgId");
		}
		List<Long> orgIds =iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
		param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
		param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));
		List<ProjectEntity> list = projectService.queryList(param);
		List<ProjectVO> voList =BeanMapper.mapList(list,ProjectVO.class);
		return CommonResponse.success("查询成功！", JSONArray.parseArray(JSONObject.toJSONString(voList)));
	}

	/**
	 * 根据项目部id查询项目信息
	 * @param projectDepartmentId
	 * @return
	 */
	@GetMapping("queryProjectByProjectDepartmentId")
	public CommonResponse<ProjectVO> queryProjectByProjectDepartmentId(@RequestParam(value = "projectDepartmentId") Long projectDepartmentId) {
		ProjectVO vo = new ProjectVO();
		QueryWrapper<ProjectEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("project_department_id", projectDepartmentId);
		ProjectEntity entity = projectService.getOne(queryWrapper);
		if(entity!=null){
			vo = BeanMapper.map(entity, ProjectVO.class);
		}
		return CommonResponse.success("查询成功！", vo);
	}

	/**
	 * 查询当前组织下所有启用且在建的项目
	 * @param orgId
	 * @return
	 */
	@GetMapping("queryProjectsByOrgId")
	@ResponseBody
	CommonResponse<List<ProjectVO>> queryProjectsByOrgId(@RequestParam("orgId") Long orgId) {
		List<Long> orgIds =iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
		QueryParam param = new QueryParam();
		param.getParams().put("status", new Parameter(QueryParam.EQ, 2)); // 在建
		param.getParams().put("state", new Parameter(QueryParam.EQ, 1)); // 启用
		param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
		param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));
		List<ProjectEntity> list = projectService.queryList(param);
		List<ProjectVO> voList =BeanMapper.mapList(list,ProjectVO.class);
		return CommonResponse.success("查询成功！", voList);
	}

	/**
	 * 查询当前组织下所有启用且在建的项目
	 * @param orgId
	 * @return
	 */
	@GetMapping("queryArrayByOrgId")
	@ResponseBody
	CommonResponse<JSONArray> queryArrayByOrgId(@RequestParam("orgId") Long orgId) {
		List<Long> orgIds =iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
		QueryParam param = new QueryParam();
		param.getParams().put("status", new Parameter(QueryParam.EQ, 2)); // 在建
		param.getParams().put("state", new Parameter(QueryParam.EQ, 1)); // 启用
		param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
		param.getParams().put("project_department_id",new Parameter(QueryParam.IN,orgIds));
		List<ProjectEntity> list = projectService.queryList(param);
		List<ProjectVO> voList =BeanMapper.mapList(list,ProjectVO.class);
		return CommonResponse.success("查询成功！", JSONArray.parseArray(JSONObject.toJSONString(voList)));
	}



}
