package com.ejianc.foundation.share.service;

import java.util.List;
import java.util.Map;

import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.framework.core.response.QueryParam;

public interface IEquipmentCategoryService {

	/**
	 * 查询设备分类列表
	 * 
	 * @param queryParam
	 * @return
	 */
	List<EquipmentCategoryEntity> queryList(QueryParam queryParam);

	/**
	 * 查询设备分类详情
	 * 
	 * @param id
	 * @return
	 */
	EquipmentCategoryVO queryDetail(Long id);

	/**
	 * 修改
	 * 
	 * @param entity
	 */
	void update(EquipmentCategoryEntity entity);

	/**
	 * 新增
	 * 
	 * @param entity
	 */
	void save(EquipmentCategoryEntity entity);

	/**
	 * 批量新增
	 *
	 * @param entity
	 */
	void insertBatch(List<EquipmentCategoryEntity> entity);

	/**
	 * 根据父ID查询设备分类列表
	 * 
	 * @param id
	 * @return
	 */
	List<EquipmentCategoryVO> queryListByPid(Long id);

	/**
	 * 删除
	 * 
	 * @param id
	 */
	void delete(Long id);

	/**
	 * 修改设备分类状态
	 * 
	 * @param enabled
	 * @param tenantId
	 * @param innerCode
	 */
	void updateEnabled(Integer enabled, Long tenantId, String innerCode);

	/**
	 * 根据分类编号查询设备
	 * 
	 * @param code
	 * @return
	 */
	List<EquipmentCategoryEntity> queryByCode(String code);

	/**
	 * 根据分类名称查询分类
	 *
	 * @param name
	 * @return
	 */
	List<EquipmentCategoryEntity> queryByName(String name);

	/**
	 * 从平台中同步设备分类信息
	 */
	void insertCategoryListFromPlatform();

	/**
	 * 查询设备分类树
	 * 
	 * @param params
	 * @return
	 */
	List<EquipmentCategoryVO> queryListTree(Map<String, Object> params);

}
