package com.ejianc.foundation.dataModel.service.impl;

import com.ejianc.foundation.dataModel.bean.DataModelColConditionEntity;
import com.ejianc.foundation.dataModel.bean.DataModelColumnEntity;
import com.ejianc.foundation.dataModel.bean.DataModelTenantColumnEntity;
import com.ejianc.foundation.dataModel.mapper.DataModelColumnMapper;
import com.ejianc.foundation.dataModel.service.IDataModelColConditionService;
import com.ejianc.foundation.dataModel.service.IDataModelColumnService;
import com.ejianc.foundation.dataModel.service.IDataModelTenantColumnService;
import com.ejianc.foundation.dataModel.vo.DataModelColConditionVO;
import com.ejianc.foundation.dataModel.vo.DataModelColumnVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/**
 * 数据模型显示字段
 * 
 * @author generator
 * 
 */
@Service("dataModelColumnService")
public class DataModelColumnServiceImpl extends BaseServiceImpl<DataModelColumnMapper, DataModelColumnEntity> implements IDataModelColumnService{


    @Autowired
    private IDataModelTenantColumnService iDataModelTenantColumnService;

    @Autowired
    private IDataModelColConditionService dataModelColConditionService;


    @Override
    public List<DataModelColumnVO> queryListByTenant(Long dataModelId) {

        QueryParam param = new QueryParam();
        param.getParams().put("modelId",new Parameter(QueryParam.EQ,dataModelId));
        List<DataModelColumnEntity> entities = queryList(param);
        List<DataModelColumnVO> voList = new ArrayList<>();
        if(ListUtil.isNotEmpty(entities)){
            for (DataModelColumnEntity entity : entities) {
                param = new QueryParam();
                param.getParams().put("columnId",new Parameter(QueryParam.EQ,entity.getId()));
                param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
                List<DataModelTenantColumnEntity> tenantColumnEntities = iDataModelTenantColumnService.queryList(param);
                if(ListUtil.isNotEmpty(tenantColumnEntities)){
                    DataModelTenantColumnEntity tenantColumnEntity = tenantColumnEntities.get(0);
                    entity.setColumnName(tenantColumnEntity.getColumnName());
                    entity.setVisible(tenantColumnEntity.getVisible());
                    entity.setSequence(tenantColumnEntity.getSequence());
                    entity.setAfterStr(tenantColumnEntity.getAfterStr());
                    entity.setAlign(tenantColumnEntity.getAlign());
                    entity.setThousands(tenantColumnEntity.getThousands());
                    entity.setTotalData(tenantColumnEntity.getTotalData());
                    entity.setScale(tenantColumnEntity.getScale());
                    entity.setMemo(tenantColumnEntity.getMemo());
                }
                DataModelColumnVO vo = BeanMapper.map(entity,DataModelColumnVO.class);
                param = new QueryParam();
                param.getParams().put("colId",new Parameter(QueryParam.EQ,entity.getId()));
                param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
                param.getOrderMap().put("sequence",QueryParam.ASC);
                List<DataModelColConditionEntity> conditionEntities = dataModelColConditionService.queryList(param,false);
                if(ListUtil.isNotEmpty(conditionEntities)){
                    vo.setConditionEntities(BeanMapper.mapList(conditionEntities, DataModelColConditionVO.class));
                }
                voList.add(vo);
            }
            voList.sort(Comparator.comparingInt(DataModelColumnVO::getSequence));
        }

        return voList;
    }

    @Override
    public void deleteByModelId(Long modelId) {

    }
}
